PRO CCSDS_TO_MJDSEC,  TIME_CODE,OUT_MJD,OUT_SEC
;
;
;***********************************************************************
;*                                    
;* *CLUSTER-JSOC PROJECT - OBSERVATION PLANNING SUB-SYSTEM - RAL
;*
;* *SUBROUTINE CCSDS_TO_MJDSEC - CONVERT FROM CSDS TIME CODE - VERSION 1.1 
;*
;* *PROJECT REFERENCE    - ADD 2.2.1 - General purpose library subroutine
;*
;* *LANGUAGE   -Fortran-90 
;*
;* *PURPOSE    -To convert a time given as CCSDS ASCII time code A
;*              (at 1 second resolution) to an integer Modified 
;*              Julian Day number and an integer number of seconds 
;*              in the day.
;*
;* *ARGUMENTS  -TIME_CODE    /C*  - enter time as CCSDS ASCII time code A
;*                                  at 1 second resolution, e.g.
;*                                  1995-02-25T17:40:00Z
;*             -OUT_MJD      /I   - returns Modified Julian Day number
;*             -OUT_SEC      /I   - returns seconds in day
;*
;* *SUBROUTINES-MJD                               
;*
;* *METHOD     -Break the CCSDS time code into its components (year,
;*              month, day, hour, minute and seconds). Call MJD function
;*              (in Clustran library) to convert date components to MJD.
;*              Convert time components to seconds in day by simple
;*              arithmetic.
;*
;*              Note that the use of two integers MJD and seconds in day
;*              is the internal standard through which times are 
;*              manipulated in JSOC planning software.
;*
;*              Note also that we use the standard form of MJD, i.e. days
;*              from 00:00 UTC on 17 November 1858, as described in 
;;*              reference works on astronomy. This is related to MJD2000
;*              (as used by ESOC) by MJD = MJD2000 + 51544  
;*
;*              This subroutine is valid for all dates between 1 March 
;*              1900 and 28 February 2100.
;*               
;*
;* *WRITTEN BY -M.A.Hapgood  DRAL UK Version 1.1  February 1995    
;*
;***********************************************************************

;* Break up the time code
      reads, time_code,format="(i4,5(1x,i2))", year,month,day,hour,min,sec

;* Calculate MJD and seconds in day
      out_mjd = mjd( year,month,day )
      out_sec = (hour*60+min)*60 + sec

END
              
