PRO  CAR2POL, C,P


;C Convert vector from Cartesian to Polar form
      p = dblarr(3)

      pole = 1.570795d0
      zero = 0.d0
      
;C Calculate radial distance      
      p(2) = sqrt(c(0)*c(0) + c(1)*c(1) + c(2)*c(2))

;C Now get latitude and longitude. Take care to deal with extremum 
;C cases where x and y are both zero          
      xy2 = c(0)*c(0) + c(1)*c(1)
      if (xy2 le zero) then begin
        if (c(1) gt zero) then begin
           p(0) = pole
        endif else begin 
           p(0) = -1.d0*pole
        endelse
           p(1) = zero
      endif else begin
           xy = sqrt(xy2)
           p(0) = atan(c(2)/xy)
           p(1) = acos(c(0)/xy)
           if (c(1) lt zero)  then  p(1) = 6.28318d0 - p(1)
      endelse

      return

END
