pro calc_dipole_2005,DATE,SUB_STATUS

;* Calculate position of north magnetic pole using dipole (n=1)
;* terms of the spherical harmonic model
;*
;* Author: Mike Hapgood
;*
;* Revision
;* 22 Jul 1997  original version
;     mar 1999  mod to IDL by kzm
; IGRF2000 updated Apr.2001 by eg
; IGRF2005 updated May 2005 by eg (10th generation of coeffs)
; Renamed from calc_dipole.pro to calc_dipole_2005.pro, May 2005, ppq
;*
       common mpole,  mcolat,mlong
          mcolat = double(0)   & mlong = double(0)

;* Specify the dipole terms of the IGRF models. We use the 1995 version -
;* namely IGRFs for 1900 to 1940, DGRFs for 1945 to 1990, IGRF for 1995
;* and extrapolated values for 2000 and 2005 based on the predicted 
;* secular variations supplied with IRGF 1995. Strictly these should
;* apply only upto 2000 but I have extended to 2005 to support planning
;* for Cluster-II ops in 2000-2003.
;*
;* The first subscript of COEFF indicates the tyep of data:
;* 1 = epoch of model, 2 = g^0_1, 3 = g^1_1 and 4 = h^1_1
;* The second subscript is the model number 
;
        n_models  = 23
        coeff = intarr(4,n_models) 
        coeff = [                                                   $
         [1900,-31543,-2298,5922] ,   [1905,-31464,-2298,5909],     $
         [1910,-31354,-2297,5898] ,   [1915,-31212,-2306,5875],     $
         [1920,-31060,-2317,5845] ,   [1925,-30926,-2318,5817],     $
         [1930,-30805,-2316,5808] ,   [1935,-30715,-2306,5812],     $
         [1940,-30654,-2292,5821] ,   [1945,-30594,-2285,5810],     $
         [1950,-30554,-2250,5815] ,   [1955,-30500,-2215,5820],     $
         [1960,-30421,-2169,5791] ,   [1965,-30334,-2119,5776],     $
         [1970,-30220,-2068,5737] ,   [1975,-30100,-2013,5675],     $
         [1980,-29992,-1956,5604] ,   [1985,-29873,-1905,5500],     $
         [1990,-29775,-1848,5406] ,   [1995,-29692,-1784,5306], $
         [2000,-29619,-1728,5186] ,   [2005,-29557,-1672,5080], $
         [2010,-29513,-1618,4973]  ]

;        [1990,-29775,-1848,5406] ,   [1995,-29682,-1789,5318],     $
;        [2000,-29615,-1728,5186] ,   [2005,-29542,-1674,5073]      ]
;*
;* Calculate MJD of first model. If requested MJD is before this,
;* exit with error
        model_date =  mjd( long(coeff(0,0)),1,1)               ;first
        end_date   =  mjd( long(coeff(0,n_models-1)),12,31)    ;last
        if ( date lt model_date or   $
             date gt end_date ) then begin
          sub_status = 5000
          goto, error_exit
        endif

;* Main loop, Scan through the models to find a pair of models whose
;* epochs bracket the date of interest
;*
;* Initialise OLD_MODEL_DATE to MJD of first model, and status code
;* to a failure value 
        old_model_date = model_date
        sub_status = 5100
;* Start of main loop
        for j = 1,n_models-1 do begin
          ;* Calculate MJD of next model
          model_date = mjd (long(coeff(0,j)),1,1 )
 
         ;* Check if the requested MJD lies between the MJDs of the previous model
         ;* and the current model
          if (date lt model_date) then begin

            ;* If so, we can now interpolate the dipole terms to the requested MJD
            ;* 1. calculate interpolation factors DELTA and ONEMINUS
                delta = double(date-old_model_date) /   $
                        double(model_date-old_model_date)
                oneminus = 1.d0 - delta

            ;* 2. Interpolate terms g^0_1, g^1_1 and h^1_1
                 g01 = coeff(1,j-1)*oneminus + coeff(1,j)*delta
                 g11 = coeff(2,j-1)*oneminus + coeff(2,j)*delta
                 h11 = coeff(3,j-1)*oneminus + coeff(3,j)*delta
  
            ;* 3. Set status code to zero (success)
                  sub_status = 0

            ;* 4. Exit Do loop. 
                     goto, exit_loop
          endif else begin

             ;* If requested MJD is greater than that for current model, save the
             ;* latter in OLD_MODEL_DATE and go round the loop again
            old_model_date = model_date
          endelse
        ;* End of main loop
        endfor
exit_loop:
;* Exit if error code set on exit from DO loop
        if (sub_status ne 0) then goto, error_exit
;*
;* Calculate colatitude and longitude of pole
;* MLONG is ambiguous, but we know it's in the 4th quadrant, so:
        mlong = atan(h11/g11)
        mlong = 6.28318d0 + mlong
;* Colatitude based on 1997 corrected formula
        mcolat = atan((g11*cos(mlong)+h11*sin(mlong))/g01)
        return
;* Come here to exit if error detected
error_exit:
        print,'calc_dipol:error_exit:',sub_status
        return
END
