       program test_velocity_trans
C
       implicit none
C
       real*8 j(6), gse(6), hseb(6), hsea(6), hs(6)
       real*8 geo(6), gci(6)
       real*8 at(6), bt(6)
       integer*4 time(2)
       real*8 am(3,3),bm(3,3), dxjul, t0, dtr, dj,djx, dj0, ut,
     +        fday, secs
       integer*4 year, istatus, day
C
       OPEN(UNIT=6,STATUS='NEW',file='data.dat')
C
       WRITE (6,*) ' Calling ICSS_VELOCITY_TRANS'
       write(6,*) 
       time(1)=1997252
       time(2)=53196000
       write(6,*) ' TIME =',time
C
C*  Convert the given millisecond of day [orb_pos_time(2)] to second of day.
C*  Convert the packed form into year and day-of-year
C
       SECS = (real(TIME(2)))/1000.0D0
       YEAR = TIME(1)/1000
       DAY  = MOD(TIME(1),1000)
       FDAY = SECS/86400.0D0
       DJ   = DXJUL(YEAR) + real(DAY) + FDAY
       DJX  = DXJUL(YEAR) + real(DAY)
       DJ0 = DXJUL(2000) + real(1) + 0.5D0
       T0 = (DJX - DJ0)/36525.D0
       UT = FDAY*24.D0
       DTR =4.D0*ATAN(1.D0)/180.D0
C
       WRITE (6,*) ' SECS =', SECS
       WRITE (6,*) ' YEAR =', YEAR
       WRITE (6,*) ' DAY  =', DAY
       WRITE (6,*) ' FDAY =', FDAY
       WRITE (6,*) ' DXJUL(YEAR) =', DXJUL(YEAR)
       WRITE (6,*) ' DJX  =', DJX
       WRITE (6,*) ' DJ0  =', DJ0
       WRITE (6,*) ' (DJX-DJ0)=',DJX-DJ0
       WRITE (6,*) ' T0*100   =', T0*100
       WRITE (6,*) ' UT   =', UT
       write(6,*) 
C
       j(1)= -1.0166373125e+6
       j(2)=  1.8964521875e+5
       j(3)=  2.1642542188e+5
       write(6,*) 'j   =', j(1),j(2),j(3)
C
       gci(1)=j(1)
       gci(2)=j(2)
       gci(3)=j(3)
       write(6,*) 'gci =', gci
C
       write(6,*) ' gci to geo(1 to 4)' 
       call ICSS_VELOCITY_TRANS(1,4,j,time,geo,am,0,istatus)
       write(6,*) 'geo=',geo
C
       write(6,*) ' gci to gse(1 to 2)' 
       call ICSS_VELOCITY_TRANS(1,2,j,time,gse,am,0,istatus)
       write(6,*) 'gse=',gse
C
       write(6,*) ' gse to hseb(2 to 5)' 
       call ICSS_VELOCITY_TRANS(2,5,gse,time,hseb,am,0,istatus)
       write(6,*) 'hseb=',hseb
C
       write(6,*) ' hseb to hsea(5 to 6)' 
       call ICSS_VELOCITY_TRANS(5,6,hseb,time,hsea,am,0,istatus)
       write(6,*) 'hsea=',hsea
C
       write(6,*) ' hseb to hs(5 to 7)' 
       call ICSS_VELOCITY_TRANS(5,7,hseb,time,hs,am,0,istatus)
       write(6,*) 'hs=',hs
C
       write(6,*) ' gse to hs(2 to 7)' 
       call ICSS_VELOCITY_TRANS(2,7,gse,time,hs,am,0,istatus)
       write(6,*) 'hs=',hs
C
       write(6,*) 'gci to hseb(1 to 5)' 
       call ICSS_VELOCITY_TRANS(1,5,gci,time,hseb,am,0,istatus)
       write(6,*) 'hseb=',hseb
C
       stop
       end











