       program test_j2000_rtn
C
       implicit none
C
       integer*4 time(2), istatus, ii
       real*8 am(3,3)
       real*8 j(3), rtn(3), sun_pos_vel(6), rtn_t(3), jp(3)
       real*8 spacecraft_pos(3), spin(3), R(3), rl(3), T(3), tl(3),
     &                N(3), rtnl(3)
C
       OPEN(UNIT=6,STATUS='NEW',file='data.dat')
C
       time(1)=1998012
       time(2)=54466181
       write(6,*) ' AT time =',time
C
       jp(1) =  7.4545669885d+5
       jp(2) = -1.1366004289d+6
       jp(3) = -4.6248674225d+5
       write(6,*) ' j2000 pos =',jp
C
       j(1) = 5.1554257632D-1
       j(2) =-7.9156295543D-1
       j(3) =-3.2809135861D-1
       write(6,*) ' j2000 att =',j
C
       call ic_pos_vel_of_sun(time,sun_pos_vel,istatus)
       write(6,*) ' j2000 sun_pos=',sun_pos_vel(1),sun_pos_vel(2),
     &                sun_pos_vel(3)

       do ii = 1,3
         spacecraft_pos(ii)=jp(ii)
         rl(ii) = spacecraft_pos(ii) - sun_pos_vel(ii)
       enddo
       call UNIT_VEC(rl,R)

       rtn_t(1) = -9.8791186723D-1
       rtn_t(2) = -1.5214958272D-1
       rtn_t(3) =  2.9675698320D-2
       write(6,*) ' rohrbaugh rtn att=', rtn_t

       call solar_spin_gci(time,spin,istatus)
       write(6,*) ' j2000 solar spin =',spin
C
       call IC_CROSS_PRODUCT(spin,R,tl)
       call UNIT_VEC(tl,T)
       call IC_CROSS_PRODUCT(R,T,N)

       write(6,*) ' j2000 R =',R
       write(6,*) ' j2000 T =',T
       write(6,*) ' j2000 N =',N
       
       am(1,1) = R(1)
       am(1,2) = R(2)
       am(1,3) = R(3)
       am(2,1) = T(1)
       am(2,2) = T(2)
       am(2,3) = T(3)
       am(3,1) = N(1)
       am(3,2) = N(2)
       am(3,3) = N(3)

       call mulmat(am,j,3,3,1,rtnl)
       write(6,*) ' rtn att ACE =',rtnl

       rtn(1)=rtn_t(1)-rtnl(1)
       rtn(2)=rtn_t(2)-rtnl(2)
       rtn(3)=rtn_t(3)-rtnl(3)
       write(6,*) ' delta_rtn=', rtn
       write(6,*)
C
        stop
        end






