C $Id: icss_pos_of_sun.f,v 1.2 1998/07/24 21:54:40 asc Exp $
CCCC
C
C  ICSS_POS_OF_SUN - return the instantaneous position and velocity of the sun
C 
C  PURPOSE:  Call internal support routine to retrieve the position and
C            velocity vectors of the sun in GCI coordinates.
C
C  UNIT TYPE:  SUBROUTINE
C
C  INVOCATION METHOD:  CALL ICSS_POS_OF_SUN (orb_pos_time, sun_pos,
C					   sun_vel, pv_status)
C
C  ARGUMENT LIST:
C
C  NAME	                  TYPE   USE  DESCRIPTION
C  ----                   ----   ---  -----------
C  ORB_POS_TIME(2)        I*4    I    TIME OF ORB. VECTOR, YEAR-DAY-MILLI OF DAY
C  SUN_POS(3)             R*8    O    POSITION OF THE SUN VECTOR
C  SUN_VEL(3)             R*8    O    VELOCITY OF THE SUN VECTOR
C  PV_STATUS		  I*4	 O    STATUS OF GETTING POS OF SUN
C
C  FILE/RECORD REFERENCES:  
C
C  NAME 	  USE	    DESCRIPTION
C  ----	    	  ---       -----------
C  SLP FILE	  I	    SOLAR/LUNAR/PLANETARY EPHEMERIS (SLP) FILE
C      
C  EXTERNAL VARIABLES: None
C
C  EXTERNAL REFERENCES:  None
C
C  ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:
C    PV_STATUS is returned as one of the following:
C	0  - Successful completion
C    	Error status returned from IC_POS_VEL_OF_SUN
C
C  ASSUMPTIONS, CONSTRAINTS, RESTRICTIONS:  NONE
C
C  DEVELOPMENT HISTORY
C
C  AUTHOR	CHANGE ID	RELEASE	  DATE	    DESCRIPTION OF CHANGE
C  ------	---------	-------   ----	    ---------------------
C  J. RIZZELLO                  B3      05/06/93    INITIAL PDL
C  B. SAMUELSON UNIX PORT               0918/96     Removed VMS specific
C                                                   references
C
C  NOTES:
c  1)  This routine was added to provide KPGS programs with the ability 
C      to access sun vector information in the SLP file, previously
c      only available to internal ICSS support routines.
c
CCCC
C
C  PDL:
C
C  Call IC_POS_VEL_OF_SUN to retrieve the position and velocity vectors
C   of the sun for the specified time.
C  If the return status is good then
C      Copy the position vector to the caller's array.
C      Copy the velocity vector to the caller's array.
C      Pass status of 0 back to caller.
C  Else
C      Return the status from IC_POS_VEL_OF SUN to caller.
C  Endif
C
CCCC
	subroutine ICSS_POS_OF_SUN (ORB_POS_TIME, SUN_POS, SUN_VEL,
     .                              PV_STATUS)
C
	IMPLICIT none
C
C*  Calling parameters
C
	integer*4   ORB_POS_TIME(2) !ISTP time format (YYYYDDD, Milli of Day)
        real*8      SUN_POS(3)      !Position of sun vector
        real*8      SUN_VEL(3)      !Velocity of sun vector
	integer*4   PV_STATUS	    !Status of getting the pos of sun
C
C*  Other Variables
C
        real*8      SUN_POS_VEL(6)  !Position and velocity of sun vectors
	integer*4   STATUS	    !Status of getting the pos and vel of sun
        integer*4   i               !loop counter
C
C   Call internal support routine to get sun position and velocity vectors.
C
      call IC_POS_VEL_OF_SUN(ORB_POS_TIME, SUN_POS_VEL, STATUS)

C
C   If status indicates call was successful, then copy position vector to
C   the callers array and pass SS$_NORMAL back to caller.
C
      if(STATUS .EQ. 0) then
           do i = 1, 3
                 SUN_POS(i) = SUN_POS_VEL(i)
                 SUN_VEL(i) = SUN_POS_VEL(i+3)
           enddo
           PV_STATUS = 0 
      else
C
C   If not successful, then pass status returned from support routine to caller.
C
           PV_STATUS = STATUS

      endif

      RETURN
C
      END
