C $Id: ic_open_time_coeff_file.f,v 1.6 2007/03/23 00:52:31 asc Exp $
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC                                                  |  SYSTEM: ISTP CDHF
CC     MODULE NAME: IC_OPEN_TIME_COEFF_FILE         |  HARDWARE: DEC VAX
CC                                                  |  OPERATING SYSTEM: VMS 5.4
CC                                                  ---------------------------
CC
CC     PURPOSE: TO OPEN THE TIMING COEFFICIENT FILE
CC
CC     INVOCATION METHOD:  CALL OPEN_TIME_COEFF_FILE(UNIT,LENGTH,IOERR)
CC   	
CC     CALLING SEQUENCE ARGUMENTS:
CC
CC      NAME   TYPE        USE      DESCRIPTION
CC     -------------------------------------------------------------------------
CC      UNIT   I*4          I       HOLDS FORTRAN LOGICAL UNIT NUMBER FOR THE
CC                                   TIMING COEFFICIENTS FILE
CC      LENGTH I*4          I       RECORD LENGTH (BYTES ON SUN, LONGWORDS ON
CC                                  ULTRIX)
CC      IOERR  I*4          O       INDICATOR OF OPEN ERROR. IF = 0, FILE WAS
CC                                   SUCCESSFULLY OPENED.
CC
CC     FILE/RECORD REFERENCES:
CC      NAME                    USE      DESCRIPTION
CC     ---------------------------------------------------------------------
CC      TIMING COEFFICIENTS     NONE     OPENED ONLY
CC
CC     EXTERNAL VARIABLES:
CC 
CC      NONE
CC 
CC     ASSUMPTIONS, CONSTRAINTS, LIMITATIONS:
CC 
CC      NONE
CC
CC     EXTERNAL REFERENCES:
CC
CC      NONE
CC
C      ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:
C       If error occurs, IOERR is returned as one of the following:
C	  1 - Error opening the Timing Coef. File
C
CC     DEVELOPMENT HISTORY:
CC     AUTHOR       CHANGE ID    RELEASE     DATE      CHANGE DESCRIPTION
CC    --------------------------------------------------------------------------
CC     C. RAYMOND      N/A       BUILD 3     9/1991    ORIGINAL DESIGN, CODE  
CC     J. LUBELCZYK    N/A       B3          9/1991    ADD ERROR HANDLING
CC     J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
CC     M. Harris                 B3R2        12/03/91  open tcf file as read
CC                                                     only
CC     B. SAMUELSON SPOF PORT    NONE        04/11/94  Change: required to port
CC       (CSC)     (see notes)                          icss routines to SPOF
CC 
CC     NOTES:
CC
CC     1. PDL IS SUPERFLUOUS FOR THIS UNIT, AS ALL IT DOES IS SIMPLY OPEN THE
CC        TIME COEFFICIENTS FILE.
CC     1.  The changes recorded under ID SPOF-PORT are required to make the
CC         ICSS coordinate conversion routines, originally developed under
CC         VAX-VMS 5.4 run on the UNIX-based workstations of the SPOF.  (Sun
CC         SPARCstations and DEC DECstations).  The changes are as follows:
CC           a.  Delete references to ICSS_INC
CC           b.  Define Message texts or files to correspond to the messages
CC               ICSS_SUCCESSFUL, etc. which are embedded in the error handling.
CC           c.  Remove references to the NAG routines F01CRF and F01CKF (matrix
CC               transposition and matrix multiplication routines).
CC     2.  In addition, to successfully run the software packages, copies of the
CC         Solar/Lunar/Planetary (SLP) file and timing coefficients file (TCC)
CC         must be ported onto the SPOF.
CC
CC
CC*****************************************************************************
      SUBROUTINE IC_OPEN_TIME_COEFF_FILE(UNIT,LENGTH,IOERR)
      INTEGER*4 UNIT,LENGTH,STATUS
      character*(100) filenm
C
      IOERR= 0
#ifdef DATDIR
       filenm = DATDIR // '/timcof.dat'
#else       
       filenm = './timcof.dat'
#endif

C       print *, 'timcof  is ', filenm

       OPEN (UNIT,file=filenm,
     1      RECL=LENGTH,FORM='UNFORMATTED',CONVERT="BIG_ENDIAN",
     2      ACCESS='DIRECT',status='OLD',IOSTAT=STATUS)

C      print *, 'timcof status is ', STATUS
      
      IF (STATUS.NE.0) THEN
	IOERR= 1
      ENDIF
      RETURN
      END
