C $Id: ic_get_coef.f,v 1.3 2003/09/09 16:29:00 ad Exp ad $
C Bruce Samuelson UNIX PORT 09/18/96      Modified original code,
C                                         removed VMS specific
C                                         references to SS$NORMAL
C	OPTIONS/EXTEND_SOURCE
	SUBROUTINE IC_GET_COEF(YEAR,
     .                         DOY,
     .		   	       G, 
     .			       H, 
     .			       G10,
     .                         G11,
     .		 	       H11,
     .			       STATUS)
	IMPLICIT NONE
C
C	** ARGUMENT DECLARATIONS
C
	INTEGER*4   YEAR, DOY, STATUS
	REAL*8	    G(66), H(66)
	REAL*8	    G10, G11, H11
C
C	** LOCAL DEFINITIONS
C
        REAL*8 A(11),B(11),G65(66),H65(66),G70(66),
     *     H70(66),G75(66),H75(66),G80(66),H80(66),G85(66),H85(66),
     *     G90(66),H90(66),G95(66),H95(66),
     *     G00(66),H00(66),DG00(45),DH00(45),
     *     G05(66),H05(66),DG05(45),DH05(45)



        REAL*8  DT, F1, F2
        INTEGER IY,IPR,IYR,KNM,N,N2,M,MN
C
      DATA G65/0.,-30334.,-2119.,-1662.,2997.,1594.,1297.,-2038.,1292.,
     *856.,957.,804.,479.,-390.,252.,-219.,358.,254.,-31.,-157.,-62.,
     *45.,61.,8.,-228.,4.,1.,-111.,75.,-57.,4.,13.,-26.,-6.,13.,1.,13.,
     *5.,-4.,-14.,0.,8.,-1.,11.,4.,8.,10.,2.,-13.,10.,-1.,-1.,5.,1.,
     *-2.,-2.,-3.,2.,-5.,-2.,4.,4.,0.,2.,2.,0./
      DATA H65/0.,0.,5776.,0.,-2016.,114.,0.,-404.,240.,-165.,0.,148.,
     *-269.,13.,-269.,0.,19.,128.,-126.,-97.,81.,0.,-11.,100.,68.,-32.,
     *-8.,-7.,0.,-61.,-27.,-2.,6.,26.,-23.,-12.,0.,7.,-12.,9.,-16.,4.,
     *24.,-3.,-17.,0.,-22.,15.,7.,-4.,-5.,10.,10.,-4.,1.,0.,2.,1.,2.,
     *6.,-4.,0.,-2.,3.,0.,-6./
c
      DATA G70/0.,-30220.,-2068.,-1781.,3000.,1611.,1287.,-2091.,1278.,
     *838.,952.,800.,461.,-395.,234.,-216.,359.,262.,-42.,-160.,-56.,
     *43.,64.,15.,-212.,2.,3.,-112.,72.,-57.,1.,14.,-22.,-2.,13.,-2.,
     *14.,6.,-2.,-13.,-3.,5.,0.,11.,3.,8.,10.,2.,-12.,10.,-1.,0.,3.,
     *1.,-1.,-3.,-3.,2.,-5.,-1.,6.,4.,1.,0.,3.,-1./
      DATA H70/0.,0.,5737.,0.,-2047.,25.,0.,-366.,251.,-196.,0.,167.,
     *-266.,26.,-279.,0.,26.,139.,-139.,-91.,83.,0.,-12.,100.,72.,-37.,
     *-6.,1.,0.,-70.,-27.,-4.,8.,23.,-23.,-11.,0.,7.,-15.,6.,-17.,6.,
     *21.,-6.,-16.,0.,-21.,16.,6.,-4.,-5.,10.,11.,-2.,1.,0.,1.,1.,3.,
     *4.,-4.,0.,-1.,3.,1.,-4./
c
      DATA G75/0.,-30100.,-2013.,-1902.,3010.,1632.,1276.,-2144.,1260.,
     *830.,946.,791.,438.,-405.,216.,-218.,356.,264.,-59.,-159.,-49.,
     *45.,66.,28.,-198.,1.,6.,-111.,71.,-56.,1.,16.,-14.,0.,12.,-5.,
     *14.,6.,-1.,-12.,-8.,4.,0.,10.,1.,7.,10.,2.,-12.,10.,-1.,-1.,4.,
     *1.,-2.,-3.,-3.,2.,-5.,-2.,5.,4.,1.,0.,3.,-1./
      DATA H75/0.,0.,5675.,0.,-2067.,-68.,0.,-333.,262.,-223.,0.,191.,
     *-265.,39.,-288.,0.,31.,148.,-152.,-83.,88.,0.,-13.,99.,75.,-41.,
     *-4.,11.,0.,-77.,-26.,-5.,10.,22.,-23.,-12.,0.,6.,-16.,4.,-19.,6.,
     *18.,-10.,-17.,0.,-21.,16.,7.,-4.,-5.,10.,11.,-3.,1.,0.,1.,1.,3.,
     *4.,-4.,-1.,-1.,3.,1.,-5./
c
      DATA G80/0.,-29992.,-1956.,-1997.,3027.,1663.,1281.,-2180.,1251.,
     *833.,938.,782.,398.,-419.,199.,-218.,357.,261.,-74.,-162.,-48.,
     *48.,66.,42.,-192.,4.,14.,-108.,72.,-59.,2.,21.,-12.,1.,11.,-2.,
     *18.,6.,0.,-11.,-7.,4.,3.,6.,-1.,5.,10.,1.,-12.,9.,-3.,-1.,7.,2.,
     *-5.,-4.,-4.,2.,-5.,-2.,5.,3.,1.,2.,3.,0./
      DATA H80/0.,0.,5604.,0.,-2129.,-200.,0.,-336.,271.,-252.,0.,212.,
     *-257.,53.,-297.,0.,46.,150.,-151.,-78.,92.,0.,-15.,93.,71.,-43.,
     *-2.,17.,0.,-82.,-27.,-5.,16.,18.,-23.,-10.,0.,7.,-18.,4.,-22.,9.,
     *16.,-13.,-15.,0.,-21.,16.,9.,-5.,-6.,9.,10.,-6.,2.,0.,1.,0.,3.,
     *6.,-4.,0.,-1.,4.,0.,-6./
c
      DATA G85/0.,-29873.,-1905.,-2072.,3044.,1687.,1296.,-2208.,1247.,
     *829.,936.,780.,361.,-424.,170.,-214.,355.,253.,-93.,-164.,-46.,
     *53.,65.,51.,-185.,4.,16.,-102.,74.,-62.,3.,24.,-6.,4.,10.,0.,21.,
     *6.,0.,-11.,-9.,4.,4.,4.,-4.,5.,10.,1.,-12.,9.,-3.,-1.,7.,1.,-5.,
     *-4.,-4.,3.,-5.,-2.,5.,3.,1.,2.,3.,0./
      DATA H85/0.,0.,5500.,0.,-2197.,-306.,0.,-310.,284.,-297.,0.,232.,
     *-249.,69.,-297.,0.,47.,150.,-154.,-75.,95.,0.,-16.,88.,69.,-48.,
     *-1.,21.,0.,-83.,-27.,-2.,20.,17.,-23.,-7.,0.,8.,-19.,5.,-23.,11.,
     *14.,-15.,-11.,0.,-21.,15.,9.,-6.,-6.,9.,9.,-7.,2.,0.,1.,0.,3.,
     *6.,-4.,0.,-1.,4.,0.,-6./
c
c  New 1990 and 1995 coefficients, updated Sep 1995
c
c  new
      DATA G90/0.,-29775., -1848., -2131.,  3059.,  1686.,  1314.,
     *     -2239.,  1248.,   802.,   939.,   780.,   325.,  -423.,
     *       141.,  -214.,   353.,   245.,  -109.,  -165.,   -36.,
     *        61.,    65.,    59.,  -178.,     3.,    18.,   -96.,
     *        77.,   -64.,     2.,    26.,    -1.,     5.,     9.,
     *         0.,    23.,     5.,    -1.,   -10.,   -12.,     3.,
     *         4.,     2.,    -6.,     4.,     9.,     1.,   -12.,
     *         9.,    -4.,    -2.,     7.,     1.,    -6.,    -3.,
     *        -4.,     2.,    -5.,    -2.,     4.,     3.,     1.,
     *         3.,     3.,     0./

      DATA H90/0.,     0.,  5406.,     0., -2279.,  -373.,     0.,
     *      -284.,   293.,  -352.,     0.,   247.,  -240.,    84.,
     *      -299.,     0.,    46.,   154.,  -153.,   -69.,    97.,
     *         0.,   -16.,    82.,    69.,   -52.,     1.,    24.,
     *         0.,   -80.,   -26.,     0.,    21.,    17.,   -23.,
     *        -4.,     0.,    10.,   -19.,     6.,   -22.,    12.,
     *        12.,   -16.,   -10.,     0.,   -20.,    15.,    11.,
     *        -7.,    -7.,     9.,     8.,    -7.,     2.,     0.,
     *         2.,     1.,     3.,     6.,    -4.,     0.,    -2.,
     *         3.,    -1.,    -6./

      DATA G95/0.,-29682., -1789., -2197.,  3074.,  1685.,  1329.,
     *     -2268.,  1249.,   769.,   941.,   782.,   291.,  -421.,
     *       116.,  -210.,   352.,   237.,  -122.,  -167.,   -26.,
     *        66.,    64.,    65.,  -172.,     2.,    17.,   -94.,
     *        78.,   -67.,     1.,    29.,     4.,     8.,    10.,
     *        -2.,    24.,     4.,    -1.,    -9.,   -14.,     4.,
     *         5.,     0.,    -7.,     4.,     9.,     1.,   -12.,
     *         9.,    -4.,    -2.,     7.,     0.,    -6.,    -3.,
     *        -4.,     2.,    -5.,    -2.,     4.,     3.,     1.,
     *         3.,     3.,     0./

      DATA H95/0.,     0.,  5318.,     0., -2356.,  -425.,     0.,
     *      -263.,   302.,  -406.,     0.,   262.,  -232.,    98.,
     *      -301.,     0.,    44.,   157.,  -152.,   -64.,    99.,
     *         0.,   -16.,    77.,    67.,   -57.,     4.,    28.,
     *         0.,   -77.,   -25.,     3.,    22.,    16.,   -23.,
     *        -3.,     0.,    12.,   -20.,     7.,   -21.,    12.,
     *        10.,   -17.,   -10.,     0.,   -19.,    15.,    11.,
     *        -7.,    -7.,     9.,     7.,    -8.,     1.,     0.,
     *         2.,     1.,     3.,     6.,    -4.,     0.,    -2.,
     *         3.,    -1.,    -6./

c
c  New 2000 coefficients, updated June 2003 by A. Davis
c
      DATA G00/0.,-29615., -1728., -2267.,  3072.,  1672.,  1341.,
     *     -2290.,  1253.,   715.,   935.,   787.,   251.,  -405.,
     *       110.,  -217.,   351.,   222.,  -131.,  -169.,   -12.,
     *        72.,    68.,    74.,  -161.,    -5.,    17.,   -91.,
     *        79.,   -74.,     0.,    33.,     9.,     7.,     8.,
     *        -2.,    25.,     6.,    -9.,    -8.,   -17.,     9.,
     *         7.,    -8.,    -7.,     5.,     9.,     3.,    -8.,
     *         6.,    -9.,    -2.,     9.,    -4.,    -8.,    -2.,
     *        -6.,     2.,    -3.,     0.,     4.,     1.,     2.,
     *         4.,     0.,    -1./

      DATA H00/0.,     0.,  5186.,     0., -2478.,  -458.,     0.,
     *      -227.,   296.,  -492.,     0.,   272.,  -232.,   119.,
     *      -304.,     0.,    44.,   172.,  -134.,   -40.,   107.,
     *         0.,   -17.,    64.,    65.,   -61.,     1.,    44.,
     *         0.,   -65.,   -24.,     6.,    24.,    15.,   -25.,
     *        -6.,     0.,    12.,   -22.,     8.,   -21.,    15.,
     *         9.,   -16.,    -3.,     0.,   -20.,    13.,    12.,
     *        -6.,    -8.,     9.,     4.,    -8.,     5.,     0.,
     *         1.,     0.,     4.,     5.,    -6.,    -1.,    -3.,
     *         0.,    -2.,    -8./

      DATA DG00/0.0,   14.6,   10.7,  -12.4,    1.1,   -1.1,    0.7,
     *         -5.4,    0.9,   -7.7,   -1.3,    1.6,   -7.3,    2.9,
     *         -3.2,    0.0,   -0.7,   -2.1,   -2.8,   -0.8,    2.5,
     *          1.0,   -0.4,    0.9,    2.0,   -0.6,   -0.3,    1.2,
     *         -0.4,   -0.4,   -0.3,    1.1,    1.1,   -0.2,    0.6,
     *         -0.9,   -0.3,    0.2,   -0.3,    0.4,   -1.0,    0.3,
     *         -0.5,   -0.7,   -0.4/

      DATA DH00/0.0,    0.0,  -22.5,    0.0,  -20.6,   -9.6,    0.0,
     *          6.0,   -0.1,  -14.2,    0.0,    2.1,    1.3,    5.0,
     *          0.3,    0.0,   -0.1,    0.6,    1.7,    1.9,    0.1,
     *          0.0,   -0.2,   -1.4,    0.0,   -0.8,    0.0,    0.9,
     *          0.0,    1.1,    0.0,    0.3,   -0.1,   -0.6,   -0.7,
     *          0.2,    0.0,    0.1,    0.0,    0.0,    0.3,    0.6,
     *         -0.4,    0.3,    0.7/

c
c  New 2005 coefficients, updated Jan 2010 A. Davis; data from Bobby Candey
c
      DATA G05/0.,-29556.8, -1671.8, -2340.5,   3047.,  1656.9,  1335.7,
     *    -2305.3,  1246.8,   674.4,   919.8,   798.2,   211.5,  -379.5,
     *      100.2,  -227.6,   354.4,   208.8,  -136.6,  -168.3,   -14.1,
     *       72.9,    69.6,    76.6,  -151.1,   -15.0,    14.7,   -86.4,
     *       79.8,   -74.4,    -1.4,    38.6,    12.3,     9.4,     5.5,
     *        2.0,    24.8,     7.7,   -11.4,    -6.8,   -18.0,    10.0,
     *        9.4,   -11.4,    -5.0,     5.6,     9.8,     3.6,    -7.0,
     *        5.0,   -10.8,    -1.3,     8.7,    -6.7,    -9.2,    -2.2,
     *       -6.3,     1.6,    -2.5,    -0.1,     3.0,     0.3,     2.1,
     *        3.9,    -0.1,    -2.2/

      DATA H05/0.,     0.0,  5080.0,     0.0, -2594.9,  -516.7,     0.0,
     *     -200.4,   269.3,  -524.5,     0.0,   281.4,  -225.8,   145.7,
     *     -304.7,     0.0,    42.7,   179.8,  -123.0,   -19.5,   103.6,
     *        0.0,   -20.2,    54.7,    63.7,   -63.4,     0.0,    50.3,
     *        0.0,   -61.4,   -22.5,     6.9,    25.4,    10.9,   -26.4,
     *       -4.8,     0.0,    11.2,   -21.0,     9.7,   -19.8,    16.1,
     *        7.7,   -12.8,    -0.1,     0.0,   -20.1,    12.9,    12.7,
     *       -6.7,    -8.1,     8.1,     2.9,    -7.9,     5.9,     0.0,
     *        2.4,     0.2,     4.4,     4.7,    -6.5,    -1.0,    -3.4,
     *       -0.9,    -2.3,    -8.0/

      DATA DG05/0.0,   8.8,    10.8,   -15.0,    -6.9,    -1.0,    -0.3,
     *         -3.1,  -0.9,    -6.8,    -2.5,     2.8,    -7.1,     5.9,
     *         -3.2,  -2.6,     0.4,    -3.0,    -1.2,     0.2,    -0.6,
     *         -0.8,   0.2,    -0.2,     2.1,    -2.1,    -0.4,     1.3,
     *         -0.4,   0.0,    -0.2,     1.1,     0.6,     0.4,    -0.5,
     *          0.9,  -0.2,     0.2,    -0.2,     0.2,    -0.2,     0.2,
     *          0.5,  -0.7,     0.5/


      DATA DH05/0.0,   0.0,   -21.3,     0.0,   -23.3,   -14.0,     0.0,
     *          5.4,  -6.5,    -2.0,     0.0,     2.0,     1.8,     5.6,
     *          0.0,   0.0,     0.1,     1.8,     2.0,     4.5,    -1.0,
     *          0.0,  -0.4,    -1.9,    -0.4,    -0.4,    -0.2,     0.9,
     *          0.0,   0.8,     0.4,     0.1,     0.2,    -0.9,    -0.3,
     *          0.3,   0.0,    -0.2,     0.2,     0.2,     0.4,     0.2,
     *         -0.3,   0.5,     0.4/
C



c
c         write(*,998)YEAR,DOY

	 IYR=0
	 IPR=0
C
30       IYR=YEAR
         IF (IYR.LT.1965) IYR=1965
         IF (IYR.GT.2015) IYR=2015
         IF (YEAR.NE.IYR.AND.IPR.EQ.0) write(*,999)IY,IYR
         IF (IYR.NE.YEAR) IPR=1
         IF (IYR.LT.1970) GOTO 50  !INTERPOLATE BETWEEN 1965 - 1970
         IF (IYR.LT.1975) GOTO 60  !INTERPOLATE BETWEEN 1970 - 1975
         IF (IYR.LT.1980) GOTO 70  !INTERPOLATE BETWEEN 1975 - 1980
         IF (IYR.LT.1985) GOTO 80  !INTERPOLATE BETWEEN 1980 - 1985
         IF (IYR.LT.1990) GOTO 90  !INTERPOLATE BETWEEN 1985 - 1990
         IF (IYR.LT.1995) GOTO 100  !INTERPOLATE BETWEEN 1990 - 1995
         IF (IYR.LT.2000) GOTO 110  !INTERPOLATE BETWEEN 1995 - 2000
         IF (IYR.LT.2005) GOTO 120  !INTERPOLATE BETWEEN 2000 - 2005
C
C
C	EXTRAPOLATE BETWEEN 2005 - 2015
C
         DT=DFLOAT(IYR)+(DFLOAT(DOY)/365)-2005.
         DO 40 N=1,66
            G(N)=G05(N)
            H(N)=H05(N)
            IF (N.GT.45) GOTO 40
            G(N)=G(N)+DG05(N)*DT
            H(N)=H(N)+DH05(N)*DT
40       CONTINUE
         GOTO 300
C
C
C	INTERPOLATE BETWEEEN 1965 - 1970
C
50       F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1965.)/5.
         F1=1.-F2
         DO 55 N=1,66
            G(N)=G65(N)*F1+G70(N)*F2
55          H(N)=H65(N)*F1+H70(N)*F2
         GOTO 300
C
C
C	INTERPOLATE BETWEEN 1970 - 1975
C
60       F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1970.)/5.
         F1=1.-F2
         DO 65 N=1,66
            G(N)=G70(N)*F1+G75(N)*F2
65          H(N)=H70(N)*F1+H75(N)*F2
         GOTO 300
C
C
C	INTERPOLATE BETWEEN 1975 - 1980
C
70       F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1975.)/5.
         F1=1.-F2
         DO 75 N=1,66
            G(N)=G75(N)*F1+G80(N)*F2
75          H(N)=H75(N)*F1+H80(N)*F2
         GOTO 300
C
C
C	INTERPOLATE BETWEEN 1980 - 1985
C
80       F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1980.)/5.
         F1=1.-F2
         DO 85 N=1,66
            G(N)=G80(N)*F1+G85(N)*F2
85          H(N)=H80(N)*F1+H85(N)*F2
         GOTO 300
C
C
C	INTERPOLATE BETWEEN 1985 - 1990
C
90       F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1985.)/5.
         F1=1.-F2
         DO 95 N=1,66
            G(N)=G85(N)*F1+G90(N)*F2
95          H(N)=H85(N)*F1+H90(N)*F2
         GOTO 300
C
C
C       INTERPOLATE BETWEEN 1990 - 1995
C
100      F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1990.)/5.
         F1=1.-F2
         DO 105 N=1,66
            G(N)=G90(N)*F1+G95(N)*F2
105         H(N)=H90(N)*F1+H95(N)*F2
         GOTO 300
C
C
C       INTERPOLATE BETWEEN 1995 - 2000
C
110      F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-1995.)/5.
         F1=1.-F2
         DO 115 N=1,66
            G(N)=G95(N)*F1+G00(N)*F2
115         H(N)=H95(N)*F1+H00(N)*F2
         GOTO 300
C
C       INTERPOLATE BETWEEN 2000 - 2005
C
120      F2=(DFLOAT(IYR)+DFLOAT(DOY)/365.-2000.)/5.
         F1=1.-F2
         DO 125 N=1,105
            G(N)=G00(N)*F1+G05(N)*F2
125         H(N)=H00(N)*F1+H05(N)*F2
         GOTO 300

C
C        -- SET UP DIPOLE CONSTANTS
C
300	 G10 = -G(2)  !TO CALCULATE THE TILT ANGLE, THE NEG OF THIS
C                     !ELEMENT IS USED.   KH
	 G11 = G(3)
	 H11 = H(3)
         STATUS = 0
      RETURN
998   FORMAT(//1X,
     * 'YEAR =',I5,'  DAY =',I5,' ****'//)
999   FORMAT(//1X,
     * 'IGRF WARNS:*** YEAR IS OUT OF INTERVAL 1965-2015: YEAR =',I5,/,
     *',        CALCULATIONS WILL BE DONE FOR IYR =',I5,' ****'//)
      END
c
c*************************************************************
c
