C $Id: ic_gci_to_geo_xx.f,v 1.2 1998/07/24 21:54:29 asc Exp $
CCCC
	subroutine IC_GCI_TO_GEO_xx (ORB_POS_TIME, TRANSFORM_MATRIX,
	1                         DERIV_MATRIX, VELOCITY_REQ )
C
	implicit none
C
C*  Calling Parameters
C
	integer*4   ORB_POS_TIME(2)  !time of orb vector, YYYYDDD, milli of day
	real*8	    TRANSFORM_MATRIX(3,3) !transformation matrix
	real*8      DERIV_MATRIX(3,3) !time derivative of TRANSFORM_MATRIX
        integer*4   VELOCITY_REQ      !flag to show value of DERIV_MATRIX
C                                !mean of date to true of date
C*  Other variables
C
 	integer*4   YEAR        !Year - YYYY
 	integer*4   DAY	        !day of year
	real*8      SECS        !Seconds
	real*8	    DXJUL	!Julian ephemeris date at beginning of year
	real*8	    FDAY	!Fraction of a day
	real*8      DJ0         !Julian Day of 2000
        real*8      T0          !TIME IN centuries from 2000
        real*8      UT          !Universal time in hours
        real*8      DTR         ! DEGREES TO RADIANS
        real*8      DJX
	REAL*8      CIRCULO, T00
C
C*  Other Variables
C
        REAL*8      THETA, EARTH_ROT_RATE
	INTEGER*4   I, J
	REAL*8      D_MATRIX(3,3)
C
C*  Begin executable code
C
	SECS = (real(ORB_POS_TIME(2)))/1000.0D0
        YEAR = ORB_POS_TIME(1)/1000
	DAY  = MOD(ORB_POS_TIME(1),1000)
	FDAY = SECS/86400.0D0
	DJX  = DXJUL(YEAR) + real(DAY)
	DJ0 = DXJUL(2000) + real(1) + 0.5d0
C
	T0 = (DJX - DJ0)/36525.d0
	T00= (DJX + FDAY - DJ0)/36525.d0
	UT = FDAY*24.d0
	DTR =4.D0*ATAN(1.D0)/180.D0
C
        THETA = 100.460618D0+36000.7700537D0*T0+15.04107D0*UT
        THETA = CIRCULO(THETA)
C
	TRANSFORM_MATRIX(1,1) = DCOS(DTR*THETA)
	TRANSFORM_MATRIX(1,2) = DSIN(DTR*THETA)
	TRANSFORM_MATRIX(1,3) = 0.D0
	TRANSFORM_MATRIX(2,1) = -TRANSFORM_MATRIX(1,2)
	TRANSFORM_MATRIX(2,2) =  TRANSFORM_MATRIX(1,1)
	TRANSFORM_MATRIX(2,3) = 0.D0
	TRANSFORM_MATRIX(3,1) = 0.D0
	TRANSFORM_MATRIX(3,2) = 0.D0
	TRANSFORM_MATRIX(3,3) = 1.D0
C
	IF (VELOCITY_REQ .GT. 0 ) THEN
           D_MATRIX(1,1) = -DSIN(DTR*THETA)*EARTH_ROT_RATE
	   D_MATRIX(1,2) =  DCOS(DTR*THETA)*EARTH_ROT_RATE
	   D_MATRIX(1,3) =  0.0d0
	   D_MATRIX(2,1) = -D_MATRIX(1,2)
	   D_MATRIX(2,2) =  D_MATRIX(1,1)
	   D_MATRIX(2,3) =  0.0d0
	   D_MATRIX(3,1) =  0.0d0
	   D_MATRIX(3,2) =  0.0d0
	   D_MATRIX(3,3) =  0.0d0
	   DO J = 1, 3
	      DO I = 1, 3
		 DERIV_MATRIX(I,J) = D_MATRIX(I,J)
	      ENDDO 
	   ENDDO
	ELSE
	   DO 100 I=1,3
	   DO 100 J=1,3
	      DERIV_MATRIX(I,J)=0.0d0
100	   CONTINUE
	ENDIF
C
        RETURN
        END












