C $Id: ic_fetch_tcc_rec.f,v 1.2 1998/07/24 21:54:28 asc Exp $
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC                                                  |  SYSTEM: ISTP CDHF
CC     MODULE NAME: IC_FETCH_TCC_REC                |  HARDWARE: DEC VAX
CC                                                  |  OPERATING SYSTEM: VMS 5.4
CC                                                  ---------------------------
CC
CC     PURPOSE: TO OBTAIN A GIVEN RECORD FROM THE TIMING COEFFICIENTS FILE
CC
CC     INVOCATION METHOD:  CALL FETCH_TCC_REC(UNIT,MJD,COEF,JARG,JAR,IOERR)
CC   	
CC     CALLING SEQUENCE ARGUMENTS:
CC
CC      NAME     TYPE        USE      DESCRIPTION
CC     --------------------------------------------------------------------------
CC      UNIT      I*4         I       HOLDS FORTRAN LOGICAL UNIT NUMBER FOR THE
CC                                     TIMING COEFFICIENTS FILE
CC      MJD       I*4         I       MODIFIED  JULIAN DATE (USED  AS TABLE 
CC                                     INDEX FOR TIMING COEFFICIENTS FILE). 
CC                                     THE NUMERICAL VALUE IS EQUAL TO THE 
CC                                     FULL JULIAN DATE FOR TIME REQUESTED
CC                                     -2430000 .
CC      COEF      R*8         O       OUTPUT MATRIX OF TIME COEFFICENTS HELD 
CC       (5,6)                         ON ONE RECORD WHICH CONTAIN THE TIME 
CC                                     SYSTEM CORRECTIONS.
CC      JARG(6)   I*4         O       OUTPUT GROUPS OF MODIFIED JULIAN DATES
CC                                     WHICH DEFINE THE BRACKET INTERVALS FOR
CC                                     COEF.  FOR EXAMPLE, COEF(1,I) ARE THE
CC                                     6 COEFFICIENTS WHICH ARE VALID BETWEEN
CC                                     THE DATES CONTAINED BY JARG(1) AND 
CC                                     JARG(2); COEF(2,I) ARE VALID IN THE 
CC                                     INTERVAL JARG(2) AND JARG(3), etc.
CC
CC      JAR       I*4          O       RECORD NUMBER
CC
CC      IOERR     I*4          O       ERROR INDICATOR.
CC
CC     FILE/RECORD REFERENCES:
CC      NAME                    USE      DESCRIPTION
CC     ---------------------------------------------------------------------
CC      TIMING COEFFICIENTS     READ          
CC
CC     EXTERNAL VARIABLES:
CC 
CC      NONE
CC 
CC     ASSUMPTIONS, CONSTRAINTS, LIMITATIONS:
CC 
CC      NONE
CC
CC     EXTERNAL REFERENCES:
CC
CC      NONE
CC
C      ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:
C
C      If an error occurs, IERR will be returned as one of the following:
C       2 - Error reading from the timing coef. file
C
CC     DEVELOPMENT HISTORY:
CC     AUTHOR       CHANGE ID    RELEASE     DATE      CHANGE DESCRIPTION
CC    --------------------------------------------------------------------------
CC     C. RAYMOND      N/A       BUILD 3     9/1991    ORIGINAL DESIGN, CODE  
CC     J. Lubelczyk              B3          9/1991    Added error handling
CC     J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
CC     B. SAMUESLON SPOF PORT       NONE    04/11/94  Change: required to port
CC    (CSC)     (see notes)                            icss routines to SPOF
CC
CC NOTES:
CC
CC    1.  The changes recorded under ID SPOF-PORT are required to make the
CC        ICSS coordinate conversion routines, originally developed under
CC        VAX-VMS 5.4 run on the UNIX-based workstations of the SPOF.  (Sun
CC        SPARCstations and DEC DECstations).  The changes are as follows:
CC           a.  Delete references to ICSS_INC 
CC           b.  Define Message texts or files to correspond to the messages
CC               ICSS_SUCCESSFUL, etc. which are embedded in the error handling.
CC           c.  Remove references to the NAG routines F01CRF and F01CKF (matrix
CC               transposition and matrix multiplication routines).
CC    2.  In addition, to successfully run the software packages, copies of the
CC        Solar/Lunar/Planetary (SLP) file and timing coefficients file (TCC)
CC        must be ported onto the SPOF.
CC
CC
CC*****************************************************************************
CC ****  START PDL *****
CC 
CC    INTITALIZE IOERR 
CC
CC    IF (MJD OUT OF BOUNDS )
CC 
CC    THEN
CC
CC       RESET MJD
CC
CC    ENDIF
CC
CC    READ DIRECTORY RECORD
CC    IF ERROR READING DIRECTORY RECORD THEN
CC      SET IOERR TO INDICATE ERROR READING TIMING COEF. FILE
CC      ABORT TO 900
CC    ENDIF
CC
CC    SEARCH FOR APPROPRIATE RECORD
CC
CC    READ RECORD WHICH HAS DESIRED DATE 
CC    IF ERROR READING RECORD THEN
CC      SET IOERR TO INDICATE ERROR READING TIMING COEF. FILE
CC      ABORT TO 900
CC    ENDIF
CC
CC    COPY COEFFICIENT PAIRS AND DATES INTO COEF, JARG
CC
CC900 CONTINUE
CC    RETURN
CC
CC ****** END PDL **********
CC*************************************************************************
      SUBROUTINE IC_FETCH_TCC_REC(UNIT,MJD,COEF,JARG,JAR,IOERR)
      IMPLICIT REAL*8 (A-H,O-Z)                                         
      REAL*4 TEMP
      INTEGER*4 UNIT,MJD,JARG,JAR,STATUS
      DIMENSION COEF(5,6),JARG(6) ,COFF(5,6)                            
      DIMENSION COEFS(30), JDIREC(2,30), JD(62), TEMP(62), ITEMP(62)    
      EQUIVALENCE (COEFS(1),COFF(1,1)), (JD(3),JDIREC(1,1)),(MAXC,JD(1))
      EQUIVALENCE (ITEMP(1),TEMP(1))                                    
      DATA NRMAX/30/                                                    
c
      IF(MJD.LT.0) MJD=0                                                
      IF(MJD.GT.1000000) MJD=1000000                                    
      ID48=1                                                            
      READ(UNIT,REC=ID48,IOSTAT=STATUS) JD
      if ( STATUS .ne. 0 ) then
         ioerr = 2 
	 GOTO 900
      endif
      JL = (MAXC-1)/5 + 1                                               
C
C     LOCATE TIME SPAN IN DIRECTORY WHICH CONTAINS INPUT TIME           
C
      DO 100 JAR=1,NRMAX                                                
      IF((MJD.GE.JDIREC(1,JAR)).AND.(MJD.LT.JDIREC(2,JAR))) GO TO 150   
  100 CONTINUE                                                          
      IF(MJD .LT. JDIREC(1,1)) GO TO 10                                 
      IF(MJD .GT. JDIREC(2,JL   ))GO TO 20                              
   10 JAR=1                                                             
      GO TO 150                                                         
   20 JAR=JL
C                                                            
C     COMPUTE RECORD NUMBER OF DESIRED TIME SPAN                        
C
  150 ID48=2*(JAR-1)+3                                                  
C
C     READ RECORD AND STORE INFORMATION IN COEF AND JARG                
C
      READ(UNIT,REC=ID48,IOSTAT=STATUS) ITEMP
      if ( STATUS .ne. 0 ) then
         ioerr = 2 
	 GOTO 900
      endif
      DO 152 I=1,30                                                     
  152 COEFS(I)=TEMP(I)                                                  
      DO 200 I=1,5                                                      
      DO 200 J=1,6                                                      
  200 COEF(I,J) = COFF(I,J)                                             
      J=40                                                              
      DO 154 I=1,6                                                      
  154 JARG(I)=ITEMP(I+J)                                                
  900 continue
      RETURN                                                            
      END                                                               
