C $Id: ic_cross_product.f,v 1.2 1998/07/24 21:54:27 asc Exp $
CCCC
C
C  IC_CROSS_PRODUCT - Calculate the cross product.
C 
C  PURPOSE:  Calculate the cross product of 2 position vectors.  Each vector
C            has 3 components.
C
C  UNIT TYPE:  SUBROUTINE
C
C  INVOCATION METHOD:  CALL IC_CROSS_PRODUCT (A, 
C                                             B, 
C                                             RESULT)
C
C  ARGUMENT LIST:
C
C  NAME	                  TYPE   USE  DESCRIPTION
C  ----                   ----   ---  -----------
C  A(3)                   R*8    I    INPUT VECTOR LEFT OF THE x SIGN
C  B(3)                   R*8    I    INPUT VECTOR RIGHT OF THE x SIGN
C  RESULT(3)              R*8    O    RESULT OF THE CROSS PRODUCT OF A AND B
C
C  FILE/RECORD REFERENCES:  NONE
C
C  EXTERNAL VARIABLES:  NONE
C
C  EXTERNAL REFERENCES:  NONE
C
C  ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:  NONE
C
C  ASSUMPTIONS, CONSTRAINTS, RESTRICTIONS:  NONE
C
C  DEVELOPMENT HISTORY
C
C  AUTHOR	CHANGE ID	RELEASE	  DATE	    DESCRIPTION OF CHANGE
C  ------	---------	-------   ----	    ---------------------
C  J. LUBELCZYK                 B1R1      12/03/90  INITIAL PDL
C  J. Lubelczyk                 B1R1      12/10/90  CODING
C  J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
C
C  NOTES:
C
CCCC
C
C  PDL:
C
C  Calculate the cross product of A and B
C
C  RETURN
C
CCCC
	subroutine IC_CROSS_PRODUCT (A, B, RESULT)
C
	implicit none
C
C*  Calling Parameters
C
	REAL*8	A(3)	  !Input vector left of the X sign
	REAL*8	B(3)      !Input vector right of the X sign
	REAL*8	RESULT(3) !Result of the cross product of A and B
C
C*  Begin Executable Code
C
	RESULT(1) = A(2)*B(3) - (A(3)*B(2))
	RESULT(2) = A(3)*B(1) - (A(1)*B(3))
	RESULT(3) = A(1)*B(2) - (A(2)*B(1))
C
	RETURN
C
	END
