C $Id: ic_conv_geo_to_gci.f,v 1.2 1998/07/24 21:54:27 asc Exp $
CCCC
C
C  IC_CONV_GEO_TO_GCI - Convert a vector from GEO to GCI coordinates
C 
C  PURPOSE:  Convert a vector in geographical coordinates into
C            a vector in GCI coordinates.
C
C  UNIT TYPE:  SUBROUTINE
C
C  INVOCATION METHOD:  CALL IC_CONV_GEO_TO_GCI (orb_pos_time, 
C                                               geo_vect, 
C                                               gci_vect)
C
C  ARGUMENT LIST:
C
C  NAME	                  TYPE   USE  DESCRIPTION
C  ----                   ----   ---  -----------
C  ORB_POS_TIME(2)        I*4    I    TIME OF ORB. VECTOR, YEAR-DAY-MILLI OF DAY
C  GEO_VECT(3)            R*8    I    GEO COORD VECTOR
C  GCI_VECT(3)            R*8    O    GCI COORD VECTOR
C
C  FILE/RECORD REFERENCES:  NONE
C
C  EXTERNAL VARIABLES:  NONE
C
C  EXTERNAL REFERENCES:
C    IC_GCI_TO_GEO    Returns the GCI to GEO transformation matrix
C    MXTRP8	      Routine that inverts rotation matrices
C    MULMAT           Routine that multiplies two matrices
C
C  ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:  NONE
C
C  ASSUMPTIONS, CONSTRAINTS, RESTRICTIONS:  NONE
C
C  DEVELOPMENT HISTORY
C
C  AUTHOR	CHANGE ID	RELEASE	  DATE	    DESCRIPTION OF CHANGE
C  ------	---------	-------   ----	    ---------------------
C  J. LUBELCZYK                 B1R1      11/28/90  INITIAL PDL
C  J. Lubelczyk                 B1R1      12/10/90  CODING
C  J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
C  C. RAYMOND   SPOF PORT       NONE      05/07/93  Change: required to port
C     (CSC)     (see notes)                          icss routines to SPOF
C
C  NOTES:
C
C     1.  The changes recorded under ID SPOF-PORT are required to make the
C         ICSS coordinate conversion routines, originally developed under
C         VAX-VMS 5.4 run on the UNIX-based workstations of the SPOF.  (Sun
C         SPARCstations and DEC DECstations).  The changes are as follows:
C            a.  Delete references to  ICSS_INC 
C            b.  Define Message texts or files to correspond to the messages
C                ICSS_SUCCESSFUL, etc. which are embedded in the error handling.
C            c.  Remove references to the NAG routines F01CRF and F01CKF (matrix
C                transposition and matrix multiplication routines).
C     2.  In addition, to successfully run the software packages, copies of the
C         Solar/Lunar/Planetary (SLP) file and timing coefficients file (TCC)
C         must be ported onto the SPOF.
C
C
CCCC
C
C  PDL:
C
C  call IC_GCI_TO_GEO to get the GCI to GEO transformation matrix
C
C  call MXTRP8 to transpose GCI_GEO_MATRIX to GEO_GCI_MATRIX
C
C  call MULMAT to calculate GCI_VECT by multiplying GEO_GCI_MATRIX and GEO_VECT
C
C  RETURN
C
CCCC
	subroutine  IC_CONV_GEO_TO_GCI (ORB_POS_TIME,
     -					GEO_VECT,
     -					GCI_VECT)
C
	implicit none
C
C*  Calling Parameters
C
	integer*4   ORB_POS_TIME(2) !Time of orb vector, YYYYDDD, milli of day
	real*8	    GEO_VECT(3)     !GEO coordinate vector
	real*8	    GCI_VECT(3)	    !GCI coordinate vector
C
C*  Other variables
C
	real*8	    TRANSFORM_MATRIX(3,3)   !Transformation matrix
        real*8      TEMP_MATRIX(3,3)        !Temporary result matrix
        real*8      DUMMY(3,3)              
        integer*4   INTDUMMY /0/
	integer*4   ROW /3/		    !# of rows in transf_matrix
	integer*4   COLUMN /3/		    !# of columns in transf_matrix
	integer*4   RC                      !row x column

C
C*  Begin executable code
C*  call IC_GCI_TO_GEO to get the GCI to GEO transformation matrix
C
	call IC_GCI_TO_GEO (ORB_POS_TIME, TRANSFORM_MATRIX, DUMMY, INTDUMMY)
	RC = ROW*COLUMN
C
C*  call MXTRP8 routine to invert the GCI_GEO_MATRIX to GEO_GCI_MATRIX
C
	call MXTRP8 (TRANSFORM_MATRIX, TEMP_MATRIX, ROW, COLUMN) 
        TRANSFORM_MATRIX(1,1) = TEMP_MATRIX(1,1)
        TRANSFORM_MATRIX(2,1) = TEMP_MATRIX(2,1)
        TRANSFORM_MATRIX(3,1) = TEMP_MATRIX(3,1)
        TRANSFORM_MATRIX(1,2) = TEMP_MATRIX(1,2)
        TRANSFORM_MATRIX(2,2) = TEMP_MATRIX(2,2)
        TRANSFORM_MATRIX(3,2) = TEMP_MATRIX(3,2)
        TRANSFORM_MATRIX(1,3) = TEMP_MATRIX(1,3)
        TRANSFORM_MATRIX(2,3) = TEMP_MATRIX(2,3)
        TRANSFORM_MATRIX(3,3) = TEMP_MATRIX(3,3)
C
C*  call MULMAT to calculate GCI_VECT by multiplying GEO_GCI_MATRIX and GEO_VECT
C
	call MULMAT (TRANSFORM_MATRIX, GEO_VECT, ROW, COLUMN, 1, GCI_VECT)
	RETURN
C
	END
