/* get_ACE_epoch.c - for a given spacecraft clock value, calculate ACE_Epoch, */
/* using spacecraft clock calibration data from the ACE_ANCIL.HDF database. */

/* Note: the function init_ACEancillary() reads the complete database into memory. */
/* It should only be called once */

/* Note: the function SCclock_to_ACEepoch() returns ACE_Epoch corresponding to a */
/* given spacecraft clock.  ACE_epoch is seconds since 00:00:00Z Jan 1, 1996 UTC. */

#include <stdio.h>
#include "hdfi.h"

void main(argc, argv)
int argc;
char *argv[];
{
  float64 scclock_start;    /* use float64 for spacecraft clock, since some */
			    /* ancillary functions need sub-second resolution */

  float64 scclock, scclock_end, skip;
  float64 ACEepoch;
  float64 SCclock_to_ACEepoch();
  int32 init_ACEancillary();
  
  
  if (argc!=5) {
      printf("Usage: get_ACEepoch hdf_file scclock_start scclock_end skip\n");
      exit(1);
  }
  scclock_start = atof(argv[2]);
  scclock_end = atof(argv[3]);
  skip = atof(argv[4]);

  /* load the data from the HDF file */
  /* init_ACEancillary() exits if there is an error */
  init_ACEancillary(argv[1]);

  /* get the ACE epoch (seconds since Jan 1, 1996 UTC) corresponding */
  /* to the scclock */
  scclock = scclock_start;
  while (scclock <= scclock_end) {
     ACEepoch=SCclock_to_ACEepoch(scclock);
     fprintf(stdout,"%.1f   %.3f\n",scclock,ACEepoch);
     scclock +=skip;
  }
  exit(0);
}
    
