/* $Id: epam_brconst.h,v 1.9 2004/09/17 21:34:31 ad Exp $ */

#include "hdfi.h"

#define EPAMRATES 8

/* #define SCCLOCKLEMS120 194861774 */
#define SCCLOCKLEMS120 111

/* rate indicies, {0,1,2,3,4,5,6,7} = {P1,P3,P5,P7,DE1,DE4,W1,fp6p} */

static uint16 epam_rn1[EPAMRATES][8]=       /* rate number locations prior to DOY 302, 2003 */
{{23,131,203,452,0,0,0,0},
 {25,133,205,454,0,0,0,0},
 {211,460,0,0,0,0,0,0},
 {213,462,0,0,0,0,0,0},
 {218,301,384,467,0,0,0,0},
 {221,304,387,470,0,0,0,0},
 {163,246,329,412,195,278,361,444},
 {157,240,323,406,189,272,355,438}};

static uint16 epam_rn2[EPAMRATES][8]=       /* rate number locations for DOY 302, 2003 and beyond */
                                            /* switch to using LEMS120 instead of LEMS30 */
{{144,227,310,393,176,259,342,425}, 
 {146,229,312,395,178,261,344,427},
 {148,231,314,397,180,263,346,429}, 
 {154,237,320,403,186,269,352,435},
 {218,301,384,467,0,0,0,0},
 {221,304,387,470,0,0,0,0},
 {163,246,329,412,195,278,361,444},
 {157,240,323,406,189,272,355,438}};

/* number of values per rate per spin pair prior to DOY 302, 2003 */
static uint8 epam_rs1[EPAMRATES]={4,4,2,2,4,4,8,8};

/* number of values per rate per spin pair for DOY 302, 2003 and beyond */
static uint8 epam_rs2[EPAMRATES]={8,8,8,8,4,4,8,8};

/* width of energy band in kev */
static uint16 epam_eb[EPAMRATES]={18, 75, 270, 850, 15, 140, 486, 459};

/* geometry factors (cm^2 - sr) */
static float32 epam_geom[EPAMRATES]={.428, .428, .428, .428, .14, .14, .103, .397};
