#include <stdio.h>
#include <string.h>

#include "hdfi.h"
#include "df.h"
#include "epam_br.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct Epam_br data;
  int ii,jj,kk,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: epam_br_read hdf_file\n");
      exit(1);
    }

  /* open hdf input file */
  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  numrec = init_rd_epam_br(hdf_fp, sd_id, "r");
  if(numrec <= 0) {
      fprintf(stderr,"No epam data\n");
      exit(-1);
  }

  ii=0;
  while((retval= read_epam_br(&data,ii++))!=FAIL) {
	  printf("%12.1lf %12.1lf %11.3E %11.3E %11.3E %11.3E %11.3E %11.3E %11.3E %11.3E %6.1f\n", 
	    data.bin_start,data.bin_end,
	    data.P1,data.P3,data.P5,data.P7,data.DE1,data.DE4,data.W1,data.fp6p,data.EPAM_livetime);
  }

  /* all done, close HDF file */

  close_rd_epam_br();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL)
    {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}
    




