#include <stdio.h>
#include <string.h>
#include <math.h>

#include "df.h"
#include "mfhdf.h"
#include "epam_br.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct Epam_br data;
  int ii,retval;
  int32 numrec,year;
  float64 epoch,fp_doy;
  int32 day, hr, min;
  float32 sec;

  int32 init_rd_epam_br();
  int32 read_epam_br();
  void close_rd_epam_br();
  int32 init_leapseconds();
  void year_fp_doy();
  void day_hr_min_sec_function();

  if (argc!=2)
    {
      printf("Usage: epam_br_read hdf_file\n");
      exit(1);
    }

  if (init_leapseconds() != 0) {
       fprintf(stderr,"\n%s: failed to init leap-seconds\n",argv[0]);
            exit(-1);
  }
  
  /* open hdf input file */
  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  numrec = init_rd_epam_br(hdf_fp, sd_id, "r");
  if(numrec <= 0) {
      fprintf(stderr,"%s: No epam data\n",argv[1]);
      exit(-1);
  }

  ii=0;
  while((retval= read_epam_br(&data,ii++))!=FAIL) {
     if ((data.EPAM_livetime > 119.0)&&(data.bin_start > 52099201)&&(data.bin_start < 900000000)&&(data.bin_end < (data.bin_start+121.0))) {
	  epoch=(data.bin_start + data.bin_end)/2;
	  year_fp_doy(epoch,&year,&fp_doy);
          day_hr_min_sec_function(year, fp_doy, &day, &hr, &min, &sec);
	  printf("%4d %03d %02d %02d %02d %11.3E %11.3E %11.3E %11.3E %11.3E %11.3E %11.3E\n",
	    year, day, hr, min, (int)(sec+0.5),
	    data.DE1,
	    data.DE4,
	    data.P1,
	    data.P3,
	    data.P5,
	    data.fp6p,
	    data.P7);
     }
	    
  }

  /* all done, close HDF file */

  close_rd_epam_br();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL)
    {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}
    
