/* scclocktoUT.c - for a given spacecraft clock value, calculate UT time */
/* using spacecraft clock calibration data from the ACE_ANCIL.HDF database. */

/* Note: the function init_ACEancillary() reads the complete database into memory. */
/* It should only be called once */

#include <stdio.h>
#include "hdfi.h"

int main(argc, argv)
int argc;
char *argv[];
{
  float64 scclock;     /* use float64 for spacecraft clock, since some */
                       /* ancillary functions need sub-second resolution */

  float64 ACEepoch, fp_doy;
  float32 sec;
  int32 year,day,hr,min;
  float64 SCclock_to_ACEepoch();
  int32 init_ACEancillary();

  int32 init_leapseconds();  
  void year_fp_doy(float64 ACEepoch,int32 *year,float64 *fp_doy);
  void day_hr_min_sec_function(int32 year, float64 fpdoy, int32 *day, int32 *hr, int32 *min, float32 *sec);
  
  
  if (argc!=3) {
      fprintf(stdout,"Usage: scclocktoUT: get_ACEepoch hdf_file scclock\n");
      exit(1);
  }
  scclock = atof(argv[2]);

  if (init_leapseconds() != 0) {
     fprintf(stdout,"scclocktoUT: failed to init leap-seconds\n");
     exit(1);
  }

  /* load the data from the HDF file */
  /* init_ACEancillary() exits if there is an error */
  init_ACEancillary(argv[1]);

  /* get the ACE epoch (seconds since Jan 1, 1996 UTC) corresponding */
  /* to the scclock */
  if((ACEepoch=SCclock_to_ACEepoch(scclock))==-1.0) {
     fprintf(stdout,"scclocktoUT: scclock out of bounds\n");
     exit(1);
  }

  year_fp_doy(ACEepoch, &year, &fp_doy);

/*  fprintf(stdout,"%4d %7.3f\n",year,fp_doy); */

  day_hr_min_sec_function(year,fp_doy,&day,&hr,&min,&sec);
  fprintf(stdout,"%4d-%03d %02d:%02d:%04.1f\n",(int)year, day,hr,min,sec);

  exit(0);
}
    
