/* get J2000, RTN, GSE attitude of ACE spacecraft for each hour of a given year of mission */

#include <stdio.h>
#include "hdfi.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int16 data_valid;    /* -1 if scclock out of bounds */
  float64 scclock;     /* use float64 for spacecraft clock, since some */
                       /* ancillary functions need sub-second resolution */
  float64 att_gse[3];  /* GSE spacecraft attitude */
  float64 att_rtn[3];  /* RTN spacecraft attitude */
  float64 att_j2gci[3];  /* J2000 GCI spacecraft attitude */

  int32 ACE_attitude_RTN2();  /* function in ancil_subs.c */
  int32 ACE_attitude_J2GCI();
  int32 ACE_attitude_GSE();
  int32 init_ACEancillary();  /* function in ancil_subs.c */
  int32 year, doy, epoch, inyear, idx, idx2, ii, secofday, oops;
  char junk1[30],junk2[30],junk3[30],junk4[30];
  FILE *fph;

  if (argc!=3) {
      printf("Usage: %s hdf_file year\n",argv[0]);
      exit(1);
  }

  /* load the data from the HDF file, this only needs to be done once */
  /* init_ACEancillary() exits if there is an error */ 

  inyear = atoi(argv[2]);
  init_ACEancillary(argv[1]);

  
  if((fph=fopen("/home/ascuser/aceprog/daily_start_clocks.db","r"))==NULL) {
    fprintf(stderr,"\nfopen: could not open start_clocks file\n");
    exit(-1);
  }
  fscanf(fph,"%s %s %s %s",junk1,junk2,junk3,junk4);

  idx = 0;
  idx2 = 0;
  fprintf(stdout,"Year %d hourly ACE attitude vectors (direction cosines) in RTN, J2000GCI, and GSE coordinate systems\n",inyear);
  fprintf(stdout,"Flag=0 indicates OK data, Flag=1 indicates spacecraft maneuver in progress. Flag=2 indicates invalid data\n");
  fprintf(stdout,"Year\tDOY\tSecofday\tFlag\tRTN_r\t\tRTN_t\t\tRTN_n\t\tJ2GCI_x\t\tJ2GCI_y\t\tJ2GCI_z\t\tGSE_x\t\tGSE_y\t\tGSE_z\n");
  while (fscanf(fph,"%d %d %d %lf",&year,&doy,&epoch,&scclock)!=EOF) {
     if (year != inyear) continue;
     if (year > inyear) break;
     for (ii=0;ii<24;ii++) {
        secofday= ii*3600;
	oops = 0;
        data_valid = ACE_attitude_RTN2(scclock + secofday, att_rtn, &idx);
	if (data_valid <0) oops = 1;
        data_valid = ACE_attitude_J2GCI(scclock + secofday, att_j2gci, &idx2);
	if (data_valid <0) oops = 1;
        data_valid = ACE_attitude_GSE(scclock + secofday, att_gse, &idx2);
	if (data_valid <0) oops = 1;
        if (!oops) {
           fprintf(stdout,"%4d\t%3d\t%8d\t%1d\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\n",
	   year,doy, secofday,data_valid,
	   att_rtn[0],att_rtn[1],att_rtn[2],
	   att_j2gci[0],att_j2gci[1],att_j2gci[2],
	   att_gse[0],att_gse[1],att_gse[2]);
        } else {
           fprintf(stdout,"%4d\t%3d\t%8d\t2\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\t% 8.5f\n",
	   year,doy, secofday, 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0);
	}
     }
  }

  exit(0);
}
    
