/* get GSE and J2000GCI position of ACE spacecraft at beginning of each day of mission */

#include <stdio.h>
#include "hdfi.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int16 data_valid;    /* -1 if scclock out of bounds */
  float64 scclock;     /* use float64 for spacecraft clock, since some */
                       /* ancillary functions need sub-second resolution */
  float64 pos_gse[3];  /* GSE spacecraft position */
  float64 pos_j2gci[3];  /* J2000 GCI spacecraft position */

  int32 ACE_position_GSE();  /* function in ancil_subs.c */
  int32 ACE_position_J2GCI2();
  int32 init_ACEancillary();  /* function in ancil_subs.c */
  int32 year, doy, epoch, idx, oops;
  char junk1[30],junk2[30],junk3[30],junk4[30];
  FILE *fph;

  if (argc!=2) {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
  }

  /* load the data from the HDF file, this only needs to be done once */
  /* init_ACEancillary() exits if there is an error */

  init_ACEancillary(argv[1]);

  
  if((fph=fopen("/home/ascuser/aceprog/daily_start_clocks.db","r"))==NULL) {
    fprintf(stderr,"\nfopen: could not open start_clocks file\n");
    exit(-1);
  }
  fscanf(fph,"%s %s %s %s",junk1,junk2,junk3,junk4);


  idx = 0;
  fprintf(stdout,"Daily ACE position in GSE and J2000 GCI coordinate systems\n");
  fprintf(stdout,"Flag=0 indicates OK data, Flag=1 indicates invalid data\n");
  fprintf(stdout,"Year\tDOY\tSecofday\tFlag\tGSE_X(km)\tGSE_y(km)\tGSE_z(km)\tJ2GCI_X(km)\tJ2GCI_y(km)\tJ2GCI_z(km)\n");
  while (fscanf(fph,"%d %d %d %lf",&year,&doy,&epoch,&scclock)!=EOF) {
     oops = 0;
     data_valid = ACE_position_GSE(scclock, pos_gse);
     if (data_valid <0) oops = 1;
     data_valid = ACE_position_J2GCI2(scclock, pos_j2gci,&idx);
     if (data_valid <0) oops = 1;
     if(!oops) {
        fprintf(stdout,"%4d\t%3d\t%8d\t%1d\t%9.1f\t%9.1f\t%9.1f\t%9.1f\t%9.1f\t%9.1f\n",
		year,doy, 0,0,
		pos_gse[0],pos_gse[1],pos_gse[2],
		pos_j2gci[0],pos_j2gci[1],pos_j2gci[2]);
     } else {
        fprintf(stdout,"%4d\t%3d\t%8d\t%1d\t%9.1f\t%9.1f\t%9.1f\t%9.1f\t%9.1f\t%9.1f\n",
		year,doy, 0,1,
		0.0,0.0,0.0,
		0.0,0.0,0.0);
     }
  }

  exit(0);
}
