;EXAMPLE IDL PROGRAM
   
; $Id$
; Author: Glenn Hamell, Ed Santiago 
; NAME: get_HDF_data.pro 
; Copyright (c) 2003, California Institute of Technology. All rights
; reserved. Unauthorized reproduction prohibited.
;
;
; CALLING SEQUENCE:  get_HDF_data
;
; PURPOSE:
;	Quickly & easily access HDF data
;
; INPUT:
;	The HDF file(s) named in the "filepath" variable below.
;
; OUTPUT:
;	A structure of the desired data fields. Optional plots or whatever
;	code modifications you would like to add.	
;
; RETURN:
;	
;
; MODIFICATION HISTORY: 
; ===================== 
; 2003Feb21-Glenn Hamell, Created. Utilizes routines by Ed Santiago.
;	 
;
;################################################
;

PRO get_HDF_data

filepath  = '/home/mussel5/level2/swepam/swepam_data_1hr.hdf'
vdataname = 'SWEPAM_data_1hr'
lstofflds = 'year,day,hr,fp_doy,proton_speed' ; NOTE: no spaces allowed

s = read_asc_hdf( filepath, vdataname, lstofflds ); GET ONLY FIELDS NAMED 
;s = read_asc_hdf( filepath, vdataname )	  ; GET ALL FIELDS IN vdataname

; HELP, s, /st
PRINT, s

; PLOT, s.fp_doy, s.Bgse_x, MIN_VALUE=-999

END
;------------------------------------------------;
