#include <stdio.h>
#include <string.h>

#include "ss2_level2_data_2hr.h"			/* swics V2 */
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SS2_data_2hr *testdata;
  int ii,jj,retval;
  int read_first_line;
  int32 numrec;
  long	ACEepoch;
  float seconds;

  if ( argc!=2 && argc!=3 ){
      printf("Usage: ss2_L2_2hr_rd hdf_file (optional: read_1st_line equals 1 means only read first line of file \n");
      exit(1);
    }

  read_first_line = (int)argv[2]; /* =1 means to read only first line of file */

  testdata=malloc(sizeof(struct SS2_data_2hr));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_ss2_level2_data_2hr(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No swics level2 2hr data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_ss2_level2_data_2hr(testdata,ii))!=-1) {

          /* get the seconds into the above DOY */
          seconds = (int)(testdata->hr * 3600 + testdata->min * 60 + testdata->sec);

          fprintf(stdout,"%4d %3d %9.3f ", testdata->year, testdata->day, seconds);

	  printf( "% 10.4e % 10.4e %2d ",
		 testdata->vHe2, testdata->vthHe2, testdata->qf_He);

	  printf( "% 10.4e % 10.4e %2d ", 
		 testdata->C6to5, testdata->C6to5_err, testdata->qf_C6to5);

	  printf( "% 10.4e % 10.4e %2d ", 
		 testdata->O7to6, testdata->O7to6_err, testdata->qf_O7to6);

	  printf( "% 10.4e % 10.4e %2d ", 
		 testdata->O8to6, testdata->O8to6_err, testdata->qf_O8to6);

	  printf( "% 10.4e % 10.4e %2d ", 
		 testdata->avqFe, testdata->avqFe_err, testdata->qf_avqFe);

	  printf( "% 10.4e % 10.4e %2d ", 
		 testdata->FetoO, testdata->FetoO_err, testdata->qf_FetoO);

	  printf( "\n" );

	  if ( read_first_line ) {
/*fprintf( stderr, "swics_L2_2hr_rd: %4d %3d %9.3f ",
 *		 testdata->year,
 *		 testdata->day,
 *		 testdata->ACEepoch ); 
 */
	    break; /* Read ONLY 1st line */
	  }
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_ss2_level2_data_2hr();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


