#include <stdio.h>
#include <string.h>
#include <time.h>


#include "sis_level2_data_Bartels.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SIS_data_Bartels *testdata;
  int ii,jj,retval;
  int32 numrec;
  time_t tloc;
  char timestr[80];
  

  if (argc!=3) {
      printf("Usage: sis_l2_bartels_rd hdf_file one_of: He, C, N, O, Ne, Mg, Si, S, Fe\n");
      exit(1);
  }

  if (
      (strcmp("He",argv[2])) &&
      (strcmp("C",argv[2])) &&
      (strcmp("N",argv[2])) &&
      (strcmp("O",argv[2])) &&
      (strcmp("Ne",argv[2])) &&
      (strcmp("Mg",argv[2])) &&
      (strcmp("Si",argv[2])) &&
      (strcmp("S",argv[2])) &&
      (strcmp("Fe",argv[2]))
     ) {
      printf("Usage: sis_l2_bartels_rd hdf_file one_of: He, C, N, O, Ne, Mg, Si, S, Fe\n");
      exit(1);
  }
     

  testdata=malloc(sizeof(struct SIS_data_Bartels));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
  }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  numrec=init_rd_sis_level2_data_Bartels(hdf_fp, sd_id, "r");

  if( numrec<=0) {
      fprintf(stderr,"No sis level2 bartels data\n");
      exit(-1);
  }

  time(&tloc);
  strftime(timestr,79,"%c",localtime(&tloc));
/*
  printf("Bartels rotation %s Data extracted from HDF file on %s\n",argv[2],timestr);
  printf("HDF File: %s\n\n",argv[1]);
  printf("fpyear  day-of-year  8-fluxes 8-counts uptime_fraction\n");
*/
  ii=0;
  while( (retval = read_sis_level2_data_Bartels(testdata,ii))!=-1 ) {
     printf("%4d %3d ",testdata->year,testdata->day);
     if (!strcmp("He",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_He[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_He[jj]);
     }
     if (!strcmp("C",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_C[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_C[jj]);
     }
     if (!strcmp("N",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_N[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_N[jj]);
     }
     if (!strcmp("O",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_O[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_O[jj]);
     }
     if (!strcmp("Ne",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Ne[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Ne[jj]);
     }
     if (!strcmp("Mg",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Mg[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Mg[jj]);
     }
     if (!strcmp("Si",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Si[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Si[jj]);
     }
     if (!strcmp("S",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_S[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_S[jj]);
     }
     if (!strcmp("Fe",argv[2])) {
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->flux_Fe[jj]);
	  for (jj=0;jj<8;jj++) printf("% 11.4e ",testdata->cnt_Fe[jj]);
     }
     printf("% 11.4e\n",
		 testdata->up_time_fraction);
     ii++;
  }

  /* all done, close HDF file */

  close_rd_sis_level2_data_Bartels();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
  }
  exit(0);
}


