#include <stdio.h>
#include <string.h>

#include "mag_level2_data_16sec.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct MAG_data_16sec *testdata;
  int ii,jj,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: mag_l2_16sec_rd hdf_file\n");
      exit(1);
    }

  testdata=malloc(sizeof(struct MAG_data_16sec));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_mag_level2_data_16sec(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No mag level2 16sec data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_mag_level2_data_16sec(testdata, ii))!=-1) {
	  printf("%d %4d %10.6f ",
		 testdata->SCclock, testdata->year, testdata->fp_doy);
	  printf("%10.3f %10.3f %10.3f ", 
		 testdata->Br, testdata->Bt, testdata->Bn);
	  printf("%10.3f %10.3f %10.3f ", 
		 testdata->Bgse_x, testdata->Bgse_y, testdata->Bgse_z);
	  printf("%10.3f %10.3f %10.3f ", 
		 testdata->Bgsm_x, testdata->Bgsm_y, testdata->Bgsm_z);
	  printf("%10.3f  %d\n", testdata->dBrms, testdata->Quality);
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_mag_level2_data_16sec();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


