/* $Id: swepam_level2_data_1hr.h,v 1.2 2002/06/11 17:57:45 asc Exp $ */

#include "hdfi.h"

struct SWEPAM_data_1hr {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

 /* SWEPAM data */
  float32 proton_density;               /* Proton Density (cm^-3) */
  float32 proton_temp;                  /* Radial Component of proton temperature (deg. Kelvin) */
  float32 He4toprotons;                 /* Ratio of alphas/protons */
  float32 proton_speed;                 /* Proton Speed (km/s) */

  float32 x_dot_GSE;                    /* X-component of proton velocity in GSE coordinates (km/s) */
  float32 y_dot_GSE;
  float32 z_dot_GSE;
  float32 x_dot_RTN;                    /* X-component of proton velocity in GSM coordinates (km/s) */
  float32 y_dot_RTN;
  float32 z_dot_RTN;
  float32 x_dot_GSM;                    /* X-component of proton velocity in RTN coordinates (km/s) */
  float32 y_dot_GSM;
  float32 z_dot_GSM;

  float32 pos_gse_x;                    /* X-component of spacecraft position in GSE coordinates (km) */                    
  float32 pos_gse_y;
  float32 pos_gse_z;
  float32 pos_gsm_x;                    /* X-component of spacecraft position in GSM coordinates (km) */                    
  float32 pos_gsm_y;
  float32 pos_gsm_z;

  float32 Electron_temp;                /* Electron Temperature (deg. Kelvin) */

  float32 fraction_time_proton_density; /* Fraction of the timing period during which data was collected */
  float32 fraction_time_proton_temp;
  float32 fraction_time_He4toprotons;
  float32 fraction_time_proton_speed;
  float32 fraction_time_dot_GSE;
  float32 fraction_time_dot_RTN;
  float32 fraction_time_Electron_temp;

  int32   weight;                       /* number of 64-sec records in the timing period */
};






