/* $Id: cris_level2_data_counts.h,v 1.1 2000/08/01 23:43:32 asc Exp $ */

#include "hdfi.h"
#include "cris_sizes.h" 

struct CRIS_data_counts {

  uint16 number_of_elements;
  uint32 number_of_data_points_abundant;
  uint32 number_of_data_points_rare;
  
  uint8   abundant[NUMBER_OF_ELEMENTS_ABUNDANT];
  uint32  time_increment_abundant;
  uint32  start_time_abundant;
  uint32  stop_time_abundant;
  
  uint32  time_abundant[NUMBER_OF_POINTS_ABUNDANT];
  float32 livetime_abundant[NUMBER_OF_POINTS_ABUNDANT];
  int16   Z_events_abundant[NUMBER_OF_POINTS_ABUNDANT][NUMBER_OF_ELEMENTS_ABUNDANT][NUMBER_OF_ENERGY_LEVELS];

  uint8   rare[NUMBER_OF_ELEMENTS_RARE];
  uint32  time_increment_rare;    
  uint32  start_time_rare;
  uint32  stop_time_rare;
  
  uint32  time_rare[NUMBER_OF_POINTS_RARE];
  float32 livetime_rare[NUMBER_OF_POINTS_RARE];
  int16   Z_events_rare[NUMBER_OF_POINTS_RARE][NUMBER_OF_ELEMENTS_RARE][NUMBER_OF_ENERGY_LEVELS];
};










