/* $Id: cris_level2_data_abundant_256s.h,v 1.1 2000/08/01 23:36:09 asc Exp $ */

#include "hdfi.h"
#include "cris_sizes.h"

/* abundant elements */
struct CRIS_data_abundant_256s {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  float32 flux_abundant_C[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_N[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_O[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_Ne[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_Mg[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_Si[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_S[NUMBER_OF_ENERGY_LEVELS];
  float32 flux_abundant_Fe[NUMBER_OF_ENERGY_LEVELS];

  float32 cnt_abundant_C[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_N[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_O[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_Ne[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_Mg[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_Si[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_S[NUMBER_OF_ENERGY_LEVELS];
  float32 cnt_abundant_Fe[NUMBER_OF_ENERGY_LEVELS];

  float32 livetime;

};









