#include <stdio.h>
#include <string.h>

#include "epam_level2_data_1hr.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct EPAM_data_1hr *testdata;
  int ii,jj,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: epam_l2_1hr_rd hdf_file\n");
      exit(1);
    }

  testdata=malloc(sizeof(struct EPAM_data_1hr));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_epam_level2_data_1hr(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No epam level2 1hr data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_epam_level2_data_1hr(testdata,ii))!=-1) {
	  printf("%4d %11.6f %3d %2d %2d %5.2f ",
		 testdata->year,testdata->fp_year,testdata->day,testdata->hr,testdata->min,testdata->sec);
	  printf("% 11.4e % 11.4e % 11.4e\n", 
		 testdata->DE1, testdata->DE2, testdata->W6);
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_epam_level2_data_1hr();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


