#include <stdio.h>
#include <string.h>

#include "sepica_level2_data_1day.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SEPICA_data_1day *testdata;
  int ii,jj,retval;
  int32 numrec;

  if (argc!=2)
    {
      printf("Usage: sepica_l2_1day_rd hdf_file\n");
      exit(1);
    }

  testdata=malloc(sizeof(struct SEPICA_data_1day));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_sepica_level2_data_1day(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No sepica level2 1day data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_sepica_level2_data_1day(testdata,ii))!=-1) {
/*	  printf("%4d %11.6f %3d %2d %2d %5.2f ", testdata->year, testdata->fp_year, testdata->day, testdata->hr, testdata->min, testdata->sec);
*/

	  printf("%4d %3d %2d %2d %5.2f ", testdata->year, testdata->day, testdata->hr, testdata->min, testdata->sec);

	  printf("%f %f %f %f %f %f %f %f %f %f\n", testdata->H1, testdata->unc_H1, testdata->He1, testdata->unc_He1, testdata->C1, testdata->unc_C1, testdata->O1, testdata->unc_O1, testdata->Fe1, testdata->unc_Fe1);
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_sepica_level2_data_1day();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


