/* $Id: $ */

/* sweswi_level2_data_12min.h */

#include "hdfi.h"

struct SWESWI_data_12min {

  /* UT time at the start of the periods */
  int32   year;                         /* integer year */
  int32   day;                          /* integer day of year */
  int32   hr;                           /* hour of day */
  int32   min;                          /* min of hour */
  float32 sec;                          /* seconds */
  float64 fp_year;                      /* floating point year */
  float64 fp_doy;                       /* floating point Day of YearDOY */ 
  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */

  /* SWEPAM/SWICS data */
  float32 proton_density;
  float32 proton_temp;
  float32 He4toprotons;
  float32 proton_speed;

  float32 x_dot_GSE;                  /* Solar Wind Velocity: x coord. GSE */
  float32 y_dot_GSE;                  /* Solar Wind Velocity: y coord. GSE */
  float32 z_dot_GSE;                  /* Solar Wind Velocity: z coord. GSE */
  float32 x_dot_RTN;                  /* Solar Wind Velocity: r coord. RTN */
  float32 y_dot_RTN;                  /* Solar Wind Velocity: t coord. RTN */
  float32 z_dot_RTN;                  /* Solar Wind Velocity: n coord. RTN */
  float32 x_dot_GSM;                  /* Solar Wind Velocity: x coord. GSM */
  float32 y_dot_GSM;                  /* Solar Wind Velocity: y coord. GSM */
  float32 z_dot_GSM;                  /* Solar Wind Velocity: z coord. GSM */

  float32 pos_gse_x;                  /* Spacecraft position: x coord. GSE */
  float32 pos_gse_y;                  /* Spacecraft position: y coord. GSE */
  float32 pos_gse_z;                  /* Spacecraft position: z coord. GSE */
  float32 pos_gsm_x;                  /* Spacecraft position: x coord. GSM */
  float32 pos_gsm_y;                  /* Spacecraft position: y coord. GSM */
  float32 pos_gsm_z;                  /* Spacecraft position: z coord. GSM */

  int32 N_swe64;                      /* Number of SWEPAM 64-second records used */
  int32 SWICS_flag;                   /* 1 if SWICS data used, 0 otherwise */
  int32 Qual_flag;                    /* Quality flag carried over from SWICS, if */
                                      /* SWICS data are used, 0 otherwise */
};
