/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id: sepica_level2_data_1hr.h,v 1.2 2001/07/03 00:05:02 steves Exp  */

#include "sepica_level2_data_1hr.h"
#include "df.h"

int32 vgrp_id_sepica_level2_data_1hr;
static int32 vdata_id_sepica_level2_data_1hr;

  /* 3879 is the size of sepica_level2_data_1hr.h + 1 added line */
char Vgrp_descrp_SEPICA_data_1hr[3879];

/****----  init create function  ----****/

int32 init_cr_sepica_level2_data_1hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_sepica_level2_data_1hr();

  void print_sepica_level2_data_1hr_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_sepica_level2_data_1hr = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_sepica_level2_data_1hr, "VG_SEPICA_data_1hr"); 
  Vsetclass(vgrp_id_sepica_level2_data_1hr, "VG_SEPICA_LEVEL2_DATA_1HR");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SEPICA_data_1hr" )) ==FAIL) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_sepica_level2_data_1hr(Vgrp_descrp_SEPICA_data_1hr);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SEPICA_data_1hr, sizeof(Vgrp_descrp_SEPICA_data_1hr))) ==FAIL) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_sepica_level2_data_1hr = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_sepica_level2_data_1hr, "SEPICA_data_1hr");
  VSsetclass(vdata_id_sepica_level2_data_1hr, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_sepica_level2_data_1hr, vdata_id_sepica_level2_data_1hr)) ==FAIL) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "year", DFNT_INT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "day", DFNT_INT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "hr", DFNT_INT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "min", DFNT_INT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "sec", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "fp_year", DFNT_FLOAT64, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "H1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define H1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "H2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define H2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "H3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define H3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He4cal", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He4cal");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He6", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He7", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "He8", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define He8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "HeCAck", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define HeCAck");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "ClowE", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define ClowE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "C1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define C1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "C2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define C2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "C3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define C3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "C4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define C4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "C5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define C5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "C6", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define C6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "OlowE", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define OlowE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "O1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define O1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "O2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define O2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "O3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define O3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "O4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define O4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "O5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define O5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Ne1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Ne1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Ne2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Ne2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Ne3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Ne3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Ne4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Ne4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Mg1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Mg1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Mg2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Mg2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Mg3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Mg3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Mg4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Mg4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Si1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Si1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Si2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Si2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Si3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Si3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Si4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Si4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "FeloE", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define FeloE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Fe1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Fe1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Fe2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Fe2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Fe3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Fe3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "Fe4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define Fe4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_H1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_H1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_H2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_H2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_H3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_H3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He4cal", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He4cal");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He6", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He7", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_He8", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_He8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_HeCAck", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_HeCAck");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_ClowE", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_ClowE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_C1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_C1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_C2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_C2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_C3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_C3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_C4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_C4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_C5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_C5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_C6", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_C6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_OlowE", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_OlowE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_O1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_O1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_O2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_O2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_O3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_O3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_O4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_O4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_O5", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_O5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Ne1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Ne2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Ne3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Ne4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Ne4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Mg1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Mg1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Mg2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Mg2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Mg3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Mg3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Mg4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Mg4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Si1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Si1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Si2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Si2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Si3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Si3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Si4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Si4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_FeloE", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_FeloE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Fe1", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Fe2", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Fe3", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "unc_Fe4", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define unc_Fe4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "up_time_fraction", DFNT_FLOAT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define up_time_fraction");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "number_of_records_120s", DFNT_INT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define number_of_records_120s");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sepica_level2_data_1hr, "number_of_records_1hr", DFNT_INT32, (1) )) {
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSfdefine: Couldn't define number_of_records_1hr");
    retval = -1;
  }

  if (VSsetfields(vdata_id_sepica_level2_data_1hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, H1, H2, H3, He1, He2, He3, He4cal, He5, He6, He7, He8, HeCAck, ClowE, C1, C2, C3, C4, C5, C6, OlowE, O1, O2, O3, O4, O5, Ne1, Ne2, Ne3, Ne4, Mg1, Mg2, Mg3, Mg4, Si1, Si2, Si3, Si4, FeloE, Fe1, Fe2, Fe3, Fe4, unc_H1, unc_H2, unc_H3, unc_He1, unc_He2, unc_He3, unc_He4cal, unc_He5, unc_He6, unc_He7, unc_He8, unc_HeCAck, unc_ClowE, unc_C1, unc_C2, unc_C3, unc_C4, unc_C5, unc_C6, unc_OlowE, unc_O1, unc_O2, unc_O3, unc_O4, unc_O5, unc_Ne1, unc_Ne2, unc_Ne3, unc_Ne4, unc_Mg1, unc_Mg2, unc_Mg3, unc_Mg4, unc_Si1, unc_Si2, unc_Si3, unc_Si4, unc_FeloE, unc_Fe1, unc_Fe2, unc_Fe3, unc_Fe4, up_time_fraction, number_of_records_120s, number_of_records_1hr")){
    print_sepica_level2_data_1hr_error("init_cr_sepica_level2_data_1hr -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_sepica_level2_data_1hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_sepica_level2_data_1hr(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_sepica_level2_data_1hr(struct SEPICA_data_1hr SEPICA_data_1hr_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_sepica_level2_data_1hr_error();
void pack_sepica_level2_data_1hr();

  odata = (uint8 *) malloc(sizeof(struct SEPICA_data_1hr));
  pack_sepica_level2_data_1hr(odata, &SEPICA_data_1hr_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_sepica_level2_data_1hr, recnum)==-1) {
		print_sepica_level2_data_1hr_error("write_sepica_level2_data_1hr -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_sepica_level2_data_1hr, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_sepica_level2_data_1hr_error("write_sepica_level2_data_1hr -> VSwrite: Couldn't write data.");

  memset(&SEPICA_data_1hr_struc, 0, sizeof(struct SEPICA_data_1hr));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_sepica_level2_data_1hr()
{
  VSdetach(vdata_id_sepica_level2_data_1hr);
  Vdetach(vgrp_id_sepica_level2_data_1hr);
}

/*----     init access function    ----*/

int32 init_acc_sepica_level2_data_1hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_sepica_level2_data_1hr_error();


  if ((vdata_ref = VSfind(hdf_fp, "SEPICA_data_1hr")) <= 0 ) {
    print_sepica_level2_data_1hr_error("init_acc_sepica_level2_data_1hr -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_sepica_level2_data_1hr = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_sepica_level2_data_1hr_error("init_acc_sepica_level2_data_1hr -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_sepica_level2_data_1hr, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_sepica_level2_data_1hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, H1, H2, H3, He1, He2, He3, He4cal, He5, He6, He7, He8, HeCAck, ClowE, C1, C2, C3, C4, C5, C6, OlowE, O1, O2, O3, O4, O5, Ne1, Ne2, Ne3, Ne4, Mg1, Mg2, Mg3, Mg4, Si1, Si2, Si3, Si4, FeloE, Fe1, Fe2, Fe3, Fe4, unc_H1, unc_H2, unc_H3, unc_He1, unc_He2, unc_He3, unc_He4cal, unc_He5, unc_He6, unc_He7, unc_He8, unc_HeCAck, unc_ClowE, unc_C1, unc_C2, unc_C3, unc_C4, unc_C5, unc_C6, unc_OlowE, unc_O1, unc_O2, unc_O3, unc_O4, unc_O5, unc_Ne1, unc_Ne2, unc_Ne3, unc_Ne4, unc_Mg1, unc_Mg2, unc_Mg3, unc_Mg4, unc_Si1, unc_Si2, unc_Si3, unc_Si4, unc_FeloE, unc_Fe1, unc_Fe2, unc_Fe3, unc_Fe4, up_time_fraction, number_of_records_120s, number_of_records_1hr")) {
      print_sepica_level2_data_1hr_error("init_acc_sepica_level2_data_1hr -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_sepica_level2_data_1hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_sepica_level2_data_1hr(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_sepica_level2_data_1hr(struct SEPICA_data_1hr *SEPICA_data_1hr_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_sepica_level2_data_1hr_error();
void unpack_sepica_level2_data_1hr();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SEPICA_data_1hr));
  VSinquire(vdata_id_sepica_level2_data_1hr, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_sepica_level2_data_1hr, recnum_rd)==FAIL) {
          print_sepica_level2_data_1hr_error("read_sepica_level2_data_1hr -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_sepica_level2_data_1hr, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_sepica_level2_data_1hr_error("read_sepica_level2_data_1hr -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_sepica_level2_data_1hr(odata, SEPICA_data_1hr_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_sepica_level2_data_1hr()
{
  VSdetach(vdata_id_sepica_level2_data_1hr);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_sepica_level2_data_1hr(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_sepica_level2_data_1hr_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SEPICA_data_1hr" )) ==FAIL)
    print_sepica_level2_data_1hr_error("rd_Vgrp_sepica_level2_data_1hr -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_sepica_level2_data_1hr_error("rd_Vgrp_sepica_level2_data_1hr -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_sepica_level2_data_1hr_error("rd_Vgrp_sepica_level2_data_1hr -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_sepica_level2_data_1hr_error("rd_Vgrp_sepica_level2_data_1hr -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SEPICA_data_1hr, HDstrlen(Vgrp_descrp_SEPICA_data_1hr)) ==FAIL)
    print_sepica_level2_data_1hr_error("rd_Vgrp_sepica_level2_data_1hr -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SEPICA_data_1hr);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_sepica_level2_data_1hr_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_sepica_level2_data_1hr.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_sepica_level2_data_1hr(uint8 *data, struct SEPICA_data_1hr *SEPICA_data_1hr_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SEPICA_data_1hr_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->H1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->H2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->H3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He4cal, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->He8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->HeCAck, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->ClowE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->C1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->C2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->C3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->C4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->C5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->C6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->OlowE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->O1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->O2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->O3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->O4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->O5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Ne1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Ne2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Ne3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Ne4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Mg1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Mg2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Mg3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Mg4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Si1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Si2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Si3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Si4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->FeloE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Fe1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Fe2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Fe3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->Fe4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_H1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_H2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_H3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He4cal, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_He8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_HeCAck, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_ClowE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_C1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_C2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_C3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_C4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_C5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_C6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_OlowE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_O1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_O2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_O3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_O4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_O5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Ne1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Ne2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Ne3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Ne4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Mg1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Mg2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Mg3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Mg4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Si1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Si2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Si3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Si4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_FeloE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Fe1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Fe2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Fe3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->unc_Fe4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->up_time_fraction, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->number_of_records_120s, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SEPICA_data_1hr_ptr->number_of_records_1hr, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_sepica_level2_data_1hr(uint8 *data, struct SEPICA_data_1hr *SEPICA_data_1hr_ptr)
{
int32 ptr=0;

   memcpy(&SEPICA_data_1hr_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SEPICA_data_1hr_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SEPICA_data_1hr_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SEPICA_data_1hr_ptr->H1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->H2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->H3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He4cal, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->He8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->HeCAck, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->ClowE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->C1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->C2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->C3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->C4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->C5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->C6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->OlowE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->O1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->O2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->O3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->O4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->O5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Ne1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Ne2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Ne3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Ne4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Mg1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Mg2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Mg3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Mg4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Si1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Si2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Si3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Si4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->FeloE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Fe1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Fe2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Fe3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->Fe4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_H1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_H2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_H3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He4cal, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_He8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_HeCAck, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_ClowE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_C1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_C2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_C3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_C4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_C5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_C6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_OlowE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_O1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_O2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_O3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_O4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_O5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Ne1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Ne2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Ne3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Ne4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Mg1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Mg2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Mg3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Mg4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Si1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Si2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Si3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Si4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_FeloE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Fe1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Fe2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Fe3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->unc_Fe4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->up_time_fraction, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->number_of_records_120s, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SEPICA_data_1hr_ptr->number_of_records_1hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_sepica_level2_data_1hr() {return(vgrp_id_sepica_level2_data_1hr);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_sepica_level2_data_1hr(char *wr_strval)
{
  strcpy(wr_strval, "The file 'sepica_level2_data_1hr.h' is shown below, it was used to create the data in the Vgroup named 'VG_SEPICA_data_1hr'.\n\n");
  strcat(wr_strval,"/* Id: sepica_level2_data_1hr.h,v 1.2 2001/07/03 00:05:02 steves Exp $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SEPICA_data_1hr {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 H1;\n");
  strcat(wr_strval,"  float32 H2;\n");
  strcat(wr_strval,"  float32 H3;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 He1;\n");
  strcat(wr_strval,"  float32 He2;\n");
  strcat(wr_strval,"  float32 He3;\n");
  strcat(wr_strval,"  float32 He4cal;		/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 He5;\n");
  strcat(wr_strval,"  float32 He6;\n");
  strcat(wr_strval,"  float32 He7;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 He8;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 HeCAck;		/* used in data version 4+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 ClowE;		/* used in data version 4+ */\n");
  strcat(wr_strval,"  float32 C1;\n");
  strcat(wr_strval,"  float32 C2;\n");
  strcat(wr_strval,"  float32 C3;\n");
  strcat(wr_strval,"  float32 C4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 C5;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 C6;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 OlowE;		/* used in data version 4+ */\n");
  strcat(wr_strval,"  float32 O1;\n");
  strcat(wr_strval,"  float32 O2;\n");
  strcat(wr_strval,"  float32 O3;\n");
  strcat(wr_strval,"  float32 O4;\n");
  strcat(wr_strval,"  float32 O5;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Ne1;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Ne2;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Ne3;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Ne4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Mg1;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Mg2;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Mg3;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Mg4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 Si1;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Si2;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Si3;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 Si4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 FeloE;		/* used in data version 4+ */\n");
  strcat(wr_strval,"  float32 Fe1;\n");
  strcat(wr_strval,"  float32 Fe2;\n");
  strcat(wr_strval,"  float32 Fe3;\n");
  strcat(wr_strval,"  float32 Fe4;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_H1;\n");
  strcat(wr_strval,"  float32 unc_H2;\n");
  strcat(wr_strval,"  float32 unc_H3;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_He1;\n");
  strcat(wr_strval,"  float32 unc_He2;\n");
  strcat(wr_strval,"  float32 unc_He3;\n");
  strcat(wr_strval,"  float32 unc_He4cal;		/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_He5;\n");
  strcat(wr_strval,"  float32 unc_He6;\n");
  strcat(wr_strval,"  float32 unc_He7;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_He8;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_HeCAck;		/* used in data version 4+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_ClowE;		/* used in data version 4+ */\n");
  strcat(wr_strval,"  float32 unc_C1;\n");
  strcat(wr_strval,"  float32 unc_C2;\n");
  strcat(wr_strval,"  float32 unc_C3;\n");
  strcat(wr_strval,"  float32 unc_C4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_C5;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_C6;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_OlowE;		/* used in data version 4+ */\n");
  strcat(wr_strval,"  float32 unc_O1;\n");
  strcat(wr_strval,"  float32 unc_O2;\n");
  strcat(wr_strval,"  float32 unc_O3;\n");
  strcat(wr_strval,"  float32 unc_O4;\n");
  strcat(wr_strval,"  float32 unc_O5;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Ne1;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Ne2;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Ne3;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Ne4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Mg1;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Mg2;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Mg3;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Mg4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_Si1;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Si2;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Si3;			/* used in data version 3+ */\n");
  strcat(wr_strval,"  float32 unc_Si4;			/* used in data version 3+ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_FeloE;		/* used in data version 4+ */\n");
  strcat(wr_strval,"  float32 unc_Fe1;\n");
  strcat(wr_strval,"  float32 unc_Fe2;\n");
  strcat(wr_strval,"  float32 unc_Fe3;\n");
  strcat(wr_strval,"  float32 unc_Fe4;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 up_time_fraction;\n");
  strcat(wr_strval,"  int32   number_of_records_120s;\n");
  strcat(wr_strval,"  int32   number_of_records_1hr;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  return(0);
}
