/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id: epam_level2_lefs150_lems30.h,v 1.1 2000/08/02 00:46:21 asc Exp  */

#include "epam_level2_lefs150_lems30.h"
#include "df.h"

int32 vgrp_id_epam_level2_lefs150_lems30;
static int32 vdata_id_epam_level2_lefs150_lems30;

  /* 1478 is the size of epam_level2_lefs150_lems30.h + 1 added line */
char Vgrp_descrp_EPAM_data_lefs150_lems30[1478];

/****----  init create function  ----****/

int32 init_cr_epam_level2_lefs150_lems30(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_epam_level2_lefs150_lems30();

  void print_epam_level2_lefs150_lems30_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_epam_level2_lefs150_lems30 = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_epam_level2_lefs150_lems30, "VG_EPAM_data_lefs150_lems30"); 
  Vsetclass(vgrp_id_epam_level2_lefs150_lems30, "VG_EPAM_LEVEL2_LEFS150_LEMS30");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_EPAM_data_lefs150_lems30" )) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_epam_level2_lefs150_lems30(Vgrp_descrp_EPAM_data_lefs150_lems30);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_EPAM_data_lefs150_lems30, sizeof(Vgrp_descrp_EPAM_data_lefs150_lems30))) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_epam_level2_lefs150_lems30 = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_epam_level2_lefs150_lems30, "EPAM_data_lefs150_lems30");
  VSsetclass(vdata_id_epam_level2_lefs150_lems30, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_epam_level2_lefs150_lems30, vdata_id_epam_level2_lefs150_lems30)) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "year", DFNT_INT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "day", DFNT_INT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "hr", DFNT_INT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "min", DFNT_INT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "sec", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "fp_year", DFNT_FLOAT64, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "E1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "E2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "E3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "E4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "FP5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "FP6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "FP7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "P8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_E1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_E2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_E3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_E4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_FP5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_FP6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_FP7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "unc_P8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define unc_P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_lefs150_lems30, "Data_Quality", DFNT_INT32, (1) )) {
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSfdefine: Couldn't define Data_Quality");
    retval = -1;
  }

  if (VSsetfields(vdata_id_epam_level2_lefs150_lems30,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, E1, E2, E3, E4, FP5, FP6, FP7, P1, P2, P3, P4, P5, P6, P7, P8, unc_E1, unc_E2, unc_E3, unc_E4, unc_FP5, unc_FP6, unc_FP7, unc_P1, unc_P2, unc_P3, unc_P4, unc_P5, unc_P6, unc_P7, unc_P8, Data_Quality")){
    print_epam_level2_lefs150_lems30_error("init_cr_epam_level2_lefs150_lems30 -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_epam_level2_lefs150_lems30(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_epam_level2_lefs150_lems30(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_epam_level2_lefs150_lems30(struct EPAM_data_lefs150_lems30 EPAM_data_lefs150_lems30_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_epam_level2_lefs150_lems30_error();
void pack_epam_level2_lefs150_lems30();

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_lefs150_lems30));
  pack_epam_level2_lefs150_lems30(odata, &EPAM_data_lefs150_lems30_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_epam_level2_lefs150_lems30, recnum)==-1) {
		print_epam_level2_lefs150_lems30_error("write_epam_level2_lefs150_lems30 -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_epam_level2_lefs150_lems30, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_epam_level2_lefs150_lems30_error("write_epam_level2_lefs150_lems30 -> VSwrite: Couldn't write data.");

  memset(&EPAM_data_lefs150_lems30_struc, 0, sizeof(struct EPAM_data_lefs150_lems30));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_epam_level2_lefs150_lems30()
{
  VSdetach(vdata_id_epam_level2_lefs150_lems30);
  Vdetach(vgrp_id_epam_level2_lefs150_lems30);
}

/*----     init access function    ----*/

int32 init_acc_epam_level2_lefs150_lems30(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_epam_level2_lefs150_lems30_error();


  if ((vdata_ref = VSfind(hdf_fp, "EPAM_data_lefs150_lems30")) <= 0 ) {
    print_epam_level2_lefs150_lems30_error("init_acc_epam_level2_lefs150_lems30 -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_epam_level2_lefs150_lems30 = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("init_acc_epam_level2_lefs150_lems30 -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_epam_level2_lefs150_lems30, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_epam_level2_lefs150_lems30,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, E1, E2, E3, E4, FP5, FP6, FP7, P1, P2, P3, P4, P5, P6, P7, P8, unc_E1, unc_E2, unc_E3, unc_E4, unc_FP5, unc_FP6, unc_FP7, unc_P1, unc_P2, unc_P3, unc_P4, unc_P5, unc_P6, unc_P7, unc_P8, Data_Quality")) {
      print_epam_level2_lefs150_lems30_error("init_acc_epam_level2_lefs150_lems30 -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_epam_level2_lefs150_lems30(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_epam_level2_lefs150_lems30(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_epam_level2_lefs150_lems30(struct EPAM_data_lefs150_lems30 *EPAM_data_lefs150_lems30_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_epam_level2_lefs150_lems30_error();
void unpack_epam_level2_lefs150_lems30();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_lefs150_lems30));
  VSinquire(vdata_id_epam_level2_lefs150_lems30, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_epam_level2_lefs150_lems30, recnum_rd)==FAIL) {
          print_epam_level2_lefs150_lems30_error("read_epam_level2_lefs150_lems30 -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_epam_level2_lefs150_lems30, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_epam_level2_lefs150_lems30_error("read_epam_level2_lefs150_lems30 -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_epam_level2_lefs150_lems30(odata, EPAM_data_lefs150_lems30_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_epam_level2_lefs150_lems30()
{
  VSdetach(vdata_id_epam_level2_lefs150_lems30);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_epam_level2_lefs150_lems30(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_epam_level2_lefs150_lems30_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_EPAM_data_lefs150_lems30" )) ==FAIL)
    print_epam_level2_lefs150_lems30_error("rd_Vgrp_epam_level2_lefs150_lems30 -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_epam_level2_lefs150_lems30_error("rd_Vgrp_epam_level2_lefs150_lems30 -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_epam_level2_lefs150_lems30_error("rd_Vgrp_epam_level2_lefs150_lems30 -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_epam_level2_lefs150_lems30_error("rd_Vgrp_epam_level2_lefs150_lems30 -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_EPAM_data_lefs150_lems30, HDstrlen(Vgrp_descrp_EPAM_data_lefs150_lems30)) ==FAIL)
    print_epam_level2_lefs150_lems30_error("rd_Vgrp_epam_level2_lefs150_lems30 -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_EPAM_data_lefs150_lems30);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_epam_level2_lefs150_lems30_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_epam_level2_lefs150_lems30.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_epam_level2_lefs150_lems30(uint8 *data, struct EPAM_data_lefs150_lems30 *EPAM_data_lefs150_lems30_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->E1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->E2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->E3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->E4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->FP5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->FP6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->FP7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->P8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_E1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_E2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_E3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_E4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_FP5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_FP6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_FP7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->unc_P8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_lefs150_lems30_ptr->Data_Quality, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_epam_level2_lefs150_lems30(uint8 *data, struct EPAM_data_lefs150_lems30 *EPAM_data_lefs150_lems30_ptr)
{
int32 ptr=0;

   memcpy(&EPAM_data_lefs150_lems30_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->E1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->E2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->E3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->E4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->FP5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->FP6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->FP7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->P8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_E1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_E2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_E3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_E4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_FP5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_FP6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_FP7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->unc_P8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_lefs150_lems30_ptr->Data_Quality, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_epam_level2_lefs150_lems30() {return(vgrp_id_epam_level2_lefs150_lems30);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_epam_level2_lefs150_lems30(char *wr_strval)
{
  strcpy(wr_strval, "The file 'epam_level2_lefs150_lems30.h' is shown below, it was used to create the data in the Vgroup named 'VG_EPAM_data_lefs150_lems30'.\n\n");
  strcat(wr_strval,"/* Id: epam_level2_lefs150_lems30.h,v 1.1 2000/08/02 00:46:21 asc Exp $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct EPAM_data_lefs150_lems30 {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 E1;\n");
  strcat(wr_strval,"  float32 E2; \n");
  strcat(wr_strval,"  float32 E3; \n");
  strcat(wr_strval,"  float32 E4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 FP5; \n");
  strcat(wr_strval,"  float32 FP6; \n");
  strcat(wr_strval,"  float32 FP7; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 P1; \n");
  strcat(wr_strval,"  float32 P2; \n");
  strcat(wr_strval,"  float32 P3; \n");
  strcat(wr_strval,"  float32 P4; \n");
  strcat(wr_strval,"  float32 P5; \n");
  strcat(wr_strval,"  float32 P6; \n");
  strcat(wr_strval,"  float32 P7; \n");
  strcat(wr_strval,"  float32 P8; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_E1;\n");
  strcat(wr_strval,"  float32 unc_E2; \n");
  strcat(wr_strval,"  float32 unc_E3; \n");
  strcat(wr_strval,"  float32 unc_E4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_FP5; \n");
  strcat(wr_strval,"  float32 unc_FP6; \n");
  strcat(wr_strval,"  float32 unc_FP7; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 unc_P1; \n");
  strcat(wr_strval,"  float32 unc_P2; \n");
  strcat(wr_strval,"  float32 unc_P3; \n");
  strcat(wr_strval,"  float32 unc_P4; \n");
  strcat(wr_strval,"  float32 unc_P5; \n");
  strcat(wr_strval,"  float32 unc_P6; \n");
  strcat(wr_strval,"  float32 unc_P7; \n");
  strcat(wr_strval,"  float32 unc_P8; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32   Data_Quality;                 /* 0=good,1=fill data */ \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  return(0);
}
