/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id: epam_level2_data_5min.h,v 1.2 2002/06/11 17:57:45 asc Exp  */

#include "epam_level2_data_5min.h"
#include "df.h"

int32 vgrp_id_epam_level2_data_5min;
static int32 vdata_id_epam_level2_data_5min;

  /* 4746 is the size of epam_level2_data_5min.h + 1 added line */
char Vgrp_descrp_EPAM_data_5min[4746];

/****----  init create function  ----****/

int32 init_cr_epam_level2_data_5min(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_epam_level2_data_5min();

  void print_epam_level2_data_5min_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_epam_level2_data_5min = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_epam_level2_data_5min, "VG_EPAM_data_5min"); 
  Vsetclass(vgrp_id_epam_level2_data_5min, "VG_EPAM_LEVEL2_DATA_5MIN");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_EPAM_data_5min" )) ==FAIL) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_epam_level2_data_5min(Vgrp_descrp_EPAM_data_5min);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_EPAM_data_5min, sizeof(Vgrp_descrp_EPAM_data_5min))) ==FAIL) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_epam_level2_data_5min = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_epam_level2_data_5min, "EPAM_data_5min");
  VSsetclass(vdata_id_epam_level2_data_5min, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_epam_level2_data_5min, vdata_id_epam_level2_data_5min)) ==FAIL) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_epam_level2_data_5min, "year", DFNT_INT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "day", DFNT_INT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "hr", DFNT_INT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "min", DFNT_INT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "sec", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "fp_year", DFNT_FLOAT64, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "DE1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "DE2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "DE3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "DE4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_DE1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_DE1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_DE2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_DE2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_DE3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_DE3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_DE4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_DE4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "W3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "W4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "W5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "W6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "W7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "W8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_W3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_W3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_W4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_W4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_W5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_W5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_W6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_W6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_W7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_W7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_W8", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_W8");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "FP5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "FP6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "FP7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_FP5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_FP5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_FP6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_FP6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_FP7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_FP7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "Z2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "Z2A", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "Z3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "Z4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_Z2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_Z2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_Z2A", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_Z2A");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_Z3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_Z3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_Z4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_Z4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "P8p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define P8p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P1p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P1p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P2p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P2p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P3p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P3p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P4p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P4p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P5p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P5p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P6p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P6p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P7p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P7p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_P8p", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_P8p");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "E4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "FP5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "FP6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "FP7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E1", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E1");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E2", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E2");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E3", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E3");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_E4", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_E4");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_FP5", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_FP5");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_FP6", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_FP6");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "unc_FP7", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define unc_FP7");
    retval = -1;
  }
  if (VSfdefine(vdata_id_epam_level2_data_5min, "livetime", DFNT_FLOAT32, (1) )) {
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSfdefine: Couldn't define livetime");
    retval = -1;
  }

  if (VSsetfields(vdata_id_epam_level2_data_5min,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, P1, P2, P3, P4, P5, P6, P7, P8, unc_P1, unc_P2, unc_P3, unc_P4, unc_P5, unc_P6, unc_P7, unc_P8, DE1, DE2, DE3, DE4, unc_DE1, unc_DE2, unc_DE3, unc_DE4, W3, W4, W5, W6, W7, W8, unc_W3, unc_W4, unc_W5, unc_W6, unc_W7, unc_W8, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, unc_E1p, unc_E2p, unc_E3p, unc_E4p, unc_FP5p, unc_FP6p, unc_FP7p, Z2, Z2A, Z3, Z4, unc_Z2, unc_Z2A, unc_Z3, unc_Z4, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p, unc_P1p, unc_P2p, unc_P3p, unc_P4p, unc_P5p, unc_P6p, unc_P7p, unc_P8p, E1, E2, E3, E4, FP5, FP6, FP7, unc_E1, unc_E2, unc_E3, unc_E4, unc_FP5, unc_FP6, unc_FP7, livetime")){
    print_epam_level2_data_5min_error("init_cr_epam_level2_data_5min -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_epam_level2_data_5min(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_epam_level2_data_5min(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_epam_level2_data_5min(struct EPAM_data_5min EPAM_data_5min_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_epam_level2_data_5min_error();
void pack_epam_level2_data_5min();

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_5min));
  pack_epam_level2_data_5min(odata, &EPAM_data_5min_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_epam_level2_data_5min, recnum)==-1) {
		print_epam_level2_data_5min_error("write_epam_level2_data_5min -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_epam_level2_data_5min, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_epam_level2_data_5min_error("write_epam_level2_data_5min -> VSwrite: Couldn't write data.");

  memset(&EPAM_data_5min_struc, 0, sizeof(struct EPAM_data_5min));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_epam_level2_data_5min()
{
  VSdetach(vdata_id_epam_level2_data_5min);
  Vdetach(vgrp_id_epam_level2_data_5min);
}

/*----     init access function    ----*/

int32 init_acc_epam_level2_data_5min(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_epam_level2_data_5min_error();


  if ((vdata_ref = VSfind(hdf_fp, "EPAM_data_5min")) <= 0 ) {
    print_epam_level2_data_5min_error("init_acc_epam_level2_data_5min -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_epam_level2_data_5min = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_epam_level2_data_5min_error("init_acc_epam_level2_data_5min -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_epam_level2_data_5min, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_epam_level2_data_5min,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, P1, P2, P3, P4, P5, P6, P7, P8, unc_P1, unc_P2, unc_P3, unc_P4, unc_P5, unc_P6, unc_P7, unc_P8, DE1, DE2, DE3, DE4, unc_DE1, unc_DE2, unc_DE3, unc_DE4, W3, W4, W5, W6, W7, W8, unc_W3, unc_W4, unc_W5, unc_W6, unc_W7, unc_W8, E1p, E2p, E3p, E4p, FP5p, FP6p, FP7p, unc_E1p, unc_E2p, unc_E3p, unc_E4p, unc_FP5p, unc_FP6p, unc_FP7p, Z2, Z2A, Z3, Z4, unc_Z2, unc_Z2A, unc_Z3, unc_Z4, P1p, P2p, P3p, P4p, P5p, P6p, P7p, P8p, unc_P1p, unc_P2p, unc_P3p, unc_P4p, unc_P5p, unc_P6p, unc_P7p, unc_P8p, E1, E2, E3, E4, FP5, FP6, FP7, unc_E1, unc_E2, unc_E3, unc_E4, unc_FP5, unc_FP6, unc_FP7, livetime")) {
      print_epam_level2_data_5min_error("init_acc_epam_level2_data_5min -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_epam_level2_data_5min(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_epam_level2_data_5min(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_epam_level2_data_5min(struct EPAM_data_5min *EPAM_data_5min_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_epam_level2_data_5min_error();
void unpack_epam_level2_data_5min();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct EPAM_data_5min));
  VSinquire(vdata_id_epam_level2_data_5min, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_epam_level2_data_5min, recnum_rd)==FAIL) {
          print_epam_level2_data_5min_error("read_epam_level2_data_5min -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_epam_level2_data_5min, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_epam_level2_data_5min_error("read_epam_level2_data_5min -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_epam_level2_data_5min(odata, EPAM_data_5min_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_epam_level2_data_5min()
{
  VSdetach(vdata_id_epam_level2_data_5min);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_epam_level2_data_5min(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_epam_level2_data_5min_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_EPAM_data_5min" )) ==FAIL)
    print_epam_level2_data_5min_error("rd_Vgrp_epam_level2_data_5min -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_epam_level2_data_5min_error("rd_Vgrp_epam_level2_data_5min -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_epam_level2_data_5min_error("rd_Vgrp_epam_level2_data_5min -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_epam_level2_data_5min_error("rd_Vgrp_epam_level2_data_5min -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_EPAM_data_5min, HDstrlen(Vgrp_descrp_EPAM_data_5min)) ==FAIL)
    print_epam_level2_data_5min_error("rd_Vgrp_epam_level2_data_5min -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_EPAM_data_5min);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_epam_level2_data_5min_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_epam_level2_data_5min.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_epam_level2_data_5min(uint8 *data, struct EPAM_data_5min *EPAM_data_5min_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &EPAM_data_5min_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->DE1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->DE2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->DE3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->DE4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_DE1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_DE2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_DE3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_DE4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->W3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->W4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->W5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->W6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->W7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->W8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_W3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_W4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_W5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_W6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_W7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_W8, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->FP5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->FP6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->FP7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_FP5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_FP6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_FP7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->Z2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->Z2A, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->Z3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->Z4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_Z2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_Z2A, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_Z3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_Z4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->P8p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P1p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P2p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P3p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P4p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P5p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P6p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P7p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_P8p, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->E4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->FP5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->FP6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->FP7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E1, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E2, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E3, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_E4, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_FP5, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_FP6, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->unc_FP7, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &EPAM_data_5min_ptr->livetime, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_epam_level2_data_5min(uint8 *data, struct EPAM_data_5min *EPAM_data_5min_ptr)
{
int32 ptr=0;

   memcpy(&EPAM_data_5min_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_5min_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_5min_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&EPAM_data_5min_ptr->P1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->DE1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->DE2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->DE3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->DE4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_DE1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_DE2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_DE3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_DE4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->W3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->W4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->W5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->W6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->W7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->W8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_W3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_W4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_W5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_W6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_W7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_W8, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->FP5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->FP6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->FP7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_FP5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_FP6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_FP7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->Z2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->Z2A, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->Z3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->Z4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_Z2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_Z2A, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_Z3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_Z4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->P8p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P1p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P2p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P3p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P4p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P5p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P6p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P7p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_P8p, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->E4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->FP5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->FP6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->FP7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E1, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E2, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E3, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_E4, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_FP5, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_FP6, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->unc_FP7, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&EPAM_data_5min_ptr->livetime, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_epam_level2_data_5min() {return(vgrp_id_epam_level2_data_5min);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_epam_level2_data_5min(char *wr_strval)
{
  strcpy(wr_strval, "The file 'epam_level2_data_5min.h' is shown below, it was used to create the data in the Vgroup named 'VG_EPAM_data_5min'.\n\n");
  strcat(wr_strval,"/* Id: epam_level2_data_5min.h,v 1.2 2002/06/11 17:57:45 asc Exp $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct EPAM_data_5min {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEMS30 ,Sector Avg,1/(cm**2-s-sr-MeV) */\n");
  strcat(wr_strval,"  float32 P1;            /* 0.047-0.065 MeV Ions */\n");
  strcat(wr_strval,"  float32 P2;            /* 0.065-0.112 MeV Ions */\n");
  strcat(wr_strval,"  float32 P3;            /* 0.112-0.187 MeV Ions */\n");
  strcat(wr_strval,"  float32 P4;            /* 0.187-0.310 MeV Ions */\n");
  strcat(wr_strval,"  float32 P5;            /* 0.310-0.580 MeV Ions */\n");
  strcat(wr_strval,"  float32 P6;            /* 0.580-1.06 MeV Ions  */\n");
  strcat(wr_strval,"  float32 P7;            /* 1.06-1.91 MeV Ions   */\n");
  strcat(wr_strval,"  float32 P8;            /* 1.91-4.75 MeV Ions   */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEMS30 uncertainties */\n");
  strcat(wr_strval,"  float32 unc_P1; \n");
  strcat(wr_strval,"  float32 unc_P2; \n");
  strcat(wr_strval,"  float32 unc_P3; \n");
  strcat(wr_strval,"  float32 unc_P4; \n");
  strcat(wr_strval,"  float32 unc_P5; \n");
  strcat(wr_strval,"  float32 unc_P6; \n");
  strcat(wr_strval,"  float32 unc_P7; \n");
  strcat(wr_strval,"  float32 unc_P8; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* DE, Sector Avg,1/(cm**2-s-sr-MeV) */\n");
  strcat(wr_strval,"  float32 DE1;           /* 0.038-0.053 MeV Electrons */\n");
  strcat(wr_strval,"  float32 DE2;           /* 0.053-0.103 MeV Electrons */\n");
  strcat(wr_strval,"  float32 DE3;           /* 0.103-0.175 MeV Electrons */\n");
  strcat(wr_strval,"  float32 DE4;           /* 0.175-0.315 MeV Electrons */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* DE uncertainties */\n");
  strcat(wr_strval,"  float32 unc_DE1; \n");
  strcat(wr_strval,"  float32 unc_DE2; \n");
  strcat(wr_strval,"  float32 unc_DE3; \n");
  strcat(wr_strval,"  float32 unc_DE4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* CA60 Sector Avg,1/(cm**2-s-sr-MeV/nuc) */\n");
  strcat(wr_strval,"/*   float32 W1; */\n");
  strcat(wr_strval,"/*   float32 W2; */\n");
  strcat(wr_strval,"  float32 W3;            /* 0.389-1.28 MeV/nuc He */\n");
  strcat(wr_strval,"  float32 W4;            /* 1.28-6.98 MeV/nuc He */\n");
  strcat(wr_strval,"  float32 W5;            /* 0.465-1.71 MeV/nuc CNO */\n");
  strcat(wr_strval,"  float32 W6;            /* 1.71-19.1 MeV/nuc CNO */\n");
  strcat(wr_strval,"  float32 W7;            /* 0.239-0.840 MeV/nuc Fe (9 < Z < 29 */\n");
  strcat(wr_strval,"  float32 W8;            /* 0.840-92.7 MeV/nuc Fe (9 < Z < 29)*/\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* CA60 uncertainties */\n");
  strcat(wr_strval,"  float32 unc_W3; \n");
  strcat(wr_strval,"  float32 unc_W4; \n");
  strcat(wr_strval,"  float32 unc_W5; \n");
  strcat(wr_strval,"  float32 unc_W6; \n");
  strcat(wr_strval,"  float32 unc_W7; \n");
  strcat(wr_strval,"  float32 unc_W8;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEFS60 Sector Avg,1/(cm**2-s-sr-MeV) */\n");
  strcat(wr_strval,"  float32 E1p;           /* 0.045-0.062 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 E2p;           /* 0.062-0.103 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 E3p;           /* 0.103-0.175 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 E4p;           /* 0.175-0.312 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 FP5p;          /* 0.546-0.761 MeV Ions */\n");
  strcat(wr_strval,"  float32 FP6p;          /* 0.761-1.22 MeV Ions */\n");
  strcat(wr_strval,"  float32 FP7p;          /* 1.22-4.97 MeV Ions */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEFS60 uncertainties */\n");
  strcat(wr_strval,"  float32 unc_E1p;\n");
  strcat(wr_strval,"  float32 unc_E2p; \n");
  strcat(wr_strval,"  float32 unc_E3p; \n");
  strcat(wr_strval,"  float32 unc_E4p; \n");
  strcat(wr_strval,"  float32 unc_FP5p; \n");
  strcat(wr_strval,"  float32 unc_FP6p; \n");
  strcat(wr_strval,"  float32 unc_FP7p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* WARTD Sector Avg,1/(cm**2-s-sr) */\n");
  strcat(wr_strval,"  float32 Z2;            /* Z>1-E>0.7 MeV Ions */\n");
  strcat(wr_strval,"  float32 Z2A;           /* Z>7-E>7.5 MeV Ions */\n");
  strcat(wr_strval,"  float32 Z3;            /* Z>5-E>2.5 MeV Ions */\n");
  strcat(wr_strval,"  float32 Z4;            /* Z>10-E>9.0 MeV Ions */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* WARTD uncertainties */\n");
  strcat(wr_strval,"  float32 unc_Z2; \n");
  strcat(wr_strval,"  float32 unc_Z2A; \n");
  strcat(wr_strval,"  float32 unc_Z3; \n");
  strcat(wr_strval,"  float32 unc_Z4; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEMS120 Sector Avg,1/(cm**2-s-sr-MeV) */\n");
  strcat(wr_strval,"  float32 P1p;           /* 0.047-0.066 MeV Ions */\n");
  strcat(wr_strval,"  float32 P2p;           /* 0.066-0.114 MeV Ions */\n");
  strcat(wr_strval,"  float32 P3p;           /* 0.114-0.190 MeV Ions */\n");
  strcat(wr_strval,"  float32 P4p;           /* 0.190-0.310 MeV Ions */\n");
  strcat(wr_strval,"  float32 P5p;           /* 0.310-0.580 MeV Ions */\n");
  strcat(wr_strval,"  float32 P6p;           /* 0.580-1.05 MeV Ions */\n");
  strcat(wr_strval,"  float32 P7p;           /* 1.05-1.89 MeV Ions */\n");
  strcat(wr_strval,"  float32 P8p;           /* 1.89-4.75 MeV Ions */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEMS120 uncertainties */\n");
  strcat(wr_strval,"  float32 unc_P1p; \n");
  strcat(wr_strval,"  float32 unc_P2p; \n");
  strcat(wr_strval,"  float32 unc_P3p; \n");
  strcat(wr_strval,"  float32 unc_P4p; \n");
  strcat(wr_strval,"  float32 unc_P5p; \n");
  strcat(wr_strval,"  float32 unc_P6p; \n");
  strcat(wr_strval,"  float32 unc_P7p; \n");
  strcat(wr_strval,"  float32 unc_P8p; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEFS150 Sector Avg,1/(cm**2-s-sr-MeV) */\n");
  strcat(wr_strval,"  float32 E1;            /* 0.045-0.062 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 E2;            /* 0.062-0.102 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 E3;            /* 0.102-0.175 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 E4;            /* 0.175-0.312 MeV Electrons (+Ions) */\n");
  strcat(wr_strval,"  float32 FP5;           /* 0.540-0.765 MeV Ions */\n");
  strcat(wr_strval,"  float32 FP6;           /* 0.765-1.22 MeV Ions */\n");
  strcat(wr_strval,"  float32 FP7;           /* 1.22-4.94 MeV Ions */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* LEFS150 uncertainties */\n");
  strcat(wr_strval,"  float32 unc_E1;\n");
  strcat(wr_strval,"  float32 unc_E2; \n");
  strcat(wr_strval,"  float32 unc_E3; \n");
  strcat(wr_strval,"  float32 unc_E4; \n");
  strcat(wr_strval,"  float32 unc_FP5; \n");
  strcat(wr_strval,"  float32 unc_FP6; \n");
  strcat(wr_strval,"  float32 unc_FP7; \n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 livetime;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"};\n");
  strcat(wr_strval,"\n");
  return(0);
}
